/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.abstracts;

import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.shaded.net.adventure.nbt.BinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.BinaryTagTypes;
import com.denizenscript.shaded.net.adventure.nbt.CompoundBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.DoubleBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.FloatBinaryTag;
import com.denizenscript.shaded.net.adventure.nbt.ListBinaryTag;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.Vector;

public abstract class ImprovedOfflinePlayer {
    public static Map<UUID, ImprovedOfflinePlayer> offlinePlayers = new HashMap<UUID, ImprovedOfflinePlayer>();
    public UUID player;
    public File file;
    public CompoundBinaryTag compound;
    public boolean exists;
    public PlayerInventory inventory;
    public Inventory enderchest;
    public boolean modified = false;
    public long timeLastLoaded = DenizenCore.currentTimeMonotonicMillis;

    public static void invalidateNow(UUID id) {
        ImprovedOfflinePlayer player = offlinePlayers.remove(id);
        if (player != null) {
            if (player.inventory != null) {
                player.setInventory(player.inventory);
            }
            if (player.enderchest != null) {
                player.setEnderChest(player.enderchest);
            }
            if (player.modified) {
                player.saveToFile();
            }
        }
    }

    public void markModified() {
        if (CoreConfiguration.debugVerbose) {
            Debug.verboseLog("[Verbose] player data modified for " + String.valueOf(this.player) + ", wasModified=" + this.modified + ", delay=" + Settings.worldPlayerDataSaveDelay);
        }
        if (Settings.worldPlayerDataSaveDelay <= 0.0f) {
            this.saveToFile();
            return;
        }
        if (!this.modified && Settings.worldPlayerDataSaveDelay < 86400.0f) {
            DenizenCore.schedule(new OneTimeSchedulable(() -> {
                if (this.modified && offlinePlayers.get(this.player) == this) {
                    this.modified = false;
                    CompoundBinaryTag tag = this.compound;
                    if (CoreConfiguration.debugVerbose) {
                        Debug.verboseLog("[Verbose] async-saving player data for " + String.valueOf(this.player));
                    }
                    DenizenCore.runAsync(() -> this.saveInternal(tag));
                }
            }, Settings.worldPlayerDataSaveDelay));
        }
        this.modified = true;
    }

    public ImprovedOfflinePlayer(UUID playeruuid) {
        this.exists = this.loadPlayerData(playeruuid);
    }

    private void modifyAbilities(UnaryOperator<CompoundBinaryTag> editor) {
        CompoundBinaryTag abilitiesCompoundTag = this.compound.getCompound("abilities");
        this.compound = (CompoundBinaryTag)this.compound.put("abilities", (BinaryTag)editor.apply(abilitiesCompoundTag));
        this.markModified();
    }

    public CompoundBinaryTag getBukkitData() {
        return this.compound.getCompound("bukkit", null);
    }

    public String getName() {
        CompoundBinaryTag bukkitData = this.getBukkitData();
        return bukkitData != null ? bukkitData.getString("lastKnownName", null) : null;
    }

    public abstract PlayerInventory getInventory();

    public abstract void setInventory(PlayerInventory var1);

    public abstract Inventory getEnderChest();

    public abstract void setEnderChest(Inventory var1);

    public Location getLocation() {
        ListBinaryTag position = this.compound.getList("Pos");
        ListBinaryTag rotation = this.compound.getList("Rotation");
        return new Location(Bukkit.getWorld((UUID)new UUID(this.compound.getLong("WorldUUIDMost"), this.compound.getLong("WorldUUIDLeast"))), position.getDouble(0), position.getDouble(1), position.getDouble(2), rotation.getFloat(0), rotation.getFloat(1));
    }

    public void setLocation(Location location) {
        World w = location.getWorld();
        UUID uuid = w.getUID();
        ListBinaryTag.Builder<DoubleBinaryTag> position = ListBinaryTag.builder(BinaryTagTypes.DOUBLE);
        position.add(DoubleBinaryTag.doubleBinaryTag(location.getX()));
        position.add(DoubleBinaryTag.doubleBinaryTag(location.getY()));
        position.add(DoubleBinaryTag.doubleBinaryTag(location.getZ()));
        ListBinaryTag.Builder<FloatBinaryTag> rotation = ListBinaryTag.builder(BinaryTagTypes.FLOAT);
        rotation.add(FloatBinaryTag.floatBinaryTag(location.getYaw()));
        rotation.add(FloatBinaryTag.floatBinaryTag(location.getPitch()));
        this.compound = ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(this.compound)).putLong("WorldUUIDMost", uuid.getMostSignificantBits())).putLong("WorldUUIDLeast", uuid.getLeastSignificantBits())).putInt("Dimension", w.getEnvironment().ordinal())).put("Pos", position.build())).put("Rotation", rotation.build())).build();
        this.markModified();
    }

    public float getHealthFloat() {
        return this.compound.getFloat("Health");
    }

    public void setHealthFloat(float input) {
        this.compound = (CompoundBinaryTag)this.compound.putFloat("Health", input);
        this.markModified();
    }

    public abstract double getMaxHealth();

    public abstract void setMaxHealth(double var1);

    protected abstract boolean loadPlayerData(UUID var1);

    public void saveToFile() {
        if (this.exists && this.modified) {
            this.modified = false;
            this.saveInternal(this.compound);
        }
    }

    public abstract void saveInternal(CompoundBinaryTag var1);

    public boolean exists() {
        return this.exists;
    }

    public float getAbsorptionAmount() {
        return this.compound.getFloat("AbsorptionAmount");
    }

    public void setAbsorptionAmount(float input) {
        this.compound = (CompoundBinaryTag)this.compound.putFloat("AbsorptionAmount", input);
        this.markModified();
    }

    public void setBedSpawnLocation(Location location) {
        if (location == null && !this.compound.keySet().contains("SpawnDimension")) {
            return;
        }
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(this.compound);
        if (location != null) {
            ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)builder.putInt("SpawnX", location.getBlockX())).putInt("SpawnY", location.getBlockY())).putInt("SpawnZ", location.getBlockZ())).putFloat("SpawnAngle", location.getYaw())).putString("SpawnDimension", location.getWorld().getKey().toString());
        } else {
            ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)builder.remove("SpawnX")).remove("SpawnY")).remove("SpawnZ")).remove("SpawnAngle")).remove("SpawnDimension");
        }
        this.compound = builder.build();
        this.markModified();
        this.saveToFile();
    }

    public boolean isSpawnForced() {
        return this.compound.getBoolean("SpawnForced");
    }

    public void setSpawnForced(boolean spawnForced) {
        this.compound = (CompoundBinaryTag)this.compound.putBoolean("SpawnForced", spawnForced);
        this.markModified();
    }

    public float getExhaustion() {
        return this.compound.getFloat("foodExhaustionLevel");
    }

    public void setExhaustion(float input) {
        this.compound = (CompoundBinaryTag)this.compound.putFloat("foodExhaustionLevel", input);
        this.markModified();
    }

    public float getExp() {
        return this.compound.getFloat("XpP");
    }

    public void setExp(float input) {
        this.compound = (CompoundBinaryTag)this.compound.putFloat("XpP", input);
        this.markModified();
    }

    public float getFallDistance() {
        return this.compound.getFloat("FallDistance");
    }

    public void setFallDistance(float input) {
        this.compound = (CompoundBinaryTag)this.compound.putFloat("FallDistance", input);
        this.markModified();
    }

    public int getFireTicks() {
        return this.compound.getShort("Fire");
    }

    public void setFireTicks(int input) {
        this.compound = (CompoundBinaryTag)this.compound.putShort("Fire", (short)input);
        this.markModified();
    }

    public float getFlySpeed() {
        return this.compound.getCompound("abilities").getFloat("flySpeed") * 2.0f;
    }

    public void setFlySpeed(float speed) {
        this.modifyAbilities(abilitiesTag -> (CompoundBinaryTag)abilitiesTag.putFloat("flySpeed", speed / 2.0f));
    }

    public int getFoodLevel() {
        return this.compound.getInt("foodLevel");
    }

    public void setFoodLevel(int input) {
        this.compound = (CompoundBinaryTag)this.compound.putInt("foodLevel", input);
        this.markModified();
    }

    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.compound.getInt("playerGameType"));
    }

    public void setGameMode(GameMode input) {
        this.compound = (CompoundBinaryTag)this.compound.putInt("playerGameType", input.getValue());
        this.markModified();
    }

    public boolean getIsOnGround() {
        return this.compound.getBoolean("OnGround");
    }

    public void setIsOnGround(boolean input) {
        this.compound = (CompoundBinaryTag)this.compound.putBoolean("OnGround", input);
        this.markModified();
    }

    public int getItemInHand() {
        return this.compound.getInt("SelectedItemSlot");
    }

    public void setItemInHand(int input) {
        this.compound = (CompoundBinaryTag)this.compound.putInt("SelectedItemSlot", input);
        this.markModified();
    }

    public int getLevel() {
        return this.compound.getInt("XpLevel");
    }

    public void setLevel(int input) {
        this.compound = (CompoundBinaryTag)this.compound.putInt("XpLevel", input);
        this.markModified();
    }

    public UUID getUniqueId() {
        return this.player;
    }

    public int getRemainingAir() {
        return this.compound.getShort("Air");
    }

    public void setRemainingAir(int input) {
        this.compound = (CompoundBinaryTag)this.compound.putShort("Air", (short)input);
        this.markModified();
    }

    public float getSaturation() {
        return this.compound.getFloat("foodSaturationLevel");
    }

    public void setSaturation(float input) {
        this.compound = (CompoundBinaryTag)this.compound.putFloat("foodSaturationLevel", input);
        this.markModified();
    }

    public float getScore() {
        return this.compound.getFloat("foodSaturationLevel");
    }

    public void setScore(int input) {
        this.compound = (CompoundBinaryTag)this.compound.putInt("Score", input);
        this.markModified();
    }

    public short getTimeAttack() {
        return this.compound.getShort("AttackTime");
    }

    public void setTimeAttack(short input) {
        this.compound = (CompoundBinaryTag)this.compound.putShort("AttackTime", input);
        this.markModified();
    }

    public short getTimeDeath() {
        return this.compound.getShort("DeathTime");
    }

    public void setTimeDeath(short input) {
        this.compound = (CompoundBinaryTag)this.compound.putShort("DeathTime", input);
        this.markModified();
    }

    public short getTimeHurt() {
        return this.compound.getShort("HurtTime");
    }

    public void setTimeHurt(short input) {
        this.compound = (CompoundBinaryTag)this.compound.putShort("HurtTime", input);
        this.markModified();
    }

    public short getTimeSleep() {
        return this.compound.getShort("SleepTimer");
    }

    public void setTimeSleep(short input) {
        this.compound = (CompoundBinaryTag)this.compound.putShort("SleepTimer", input);
        this.markModified();
    }

    public int getTotalExperience() {
        return this.compound.getInt("XpTotal");
    }

    public void setTotalExperience(int input) {
        this.compound = (CompoundBinaryTag)this.compound.putInt("XpTotal", input);
        this.markModified();
    }

    public Vector getVelocity() {
        ListBinaryTag list = this.compound.getList("Motion");
        return new Vector(list.getDouble(0), list.getDouble(1), list.getDouble(2));
    }

    public void setVelocity(Vector vector) {
        ListBinaryTag.Builder<DoubleBinaryTag> motionBuilder = ListBinaryTag.builder(BinaryTagTypes.DOUBLE);
        motionBuilder.add(DoubleBinaryTag.doubleBinaryTag(vector.getX()));
        motionBuilder.add(DoubleBinaryTag.doubleBinaryTag(vector.getY()));
        motionBuilder.add(DoubleBinaryTag.doubleBinaryTag(vector.getZ()));
        this.compound = (CompoundBinaryTag)this.compound.put("Motion", motionBuilder.build());
        this.markModified();
    }

    public float getWalkSpeed() {
        return this.compound.getCompound("abilities").getFloat("walkSpeed") * 2.0f;
    }

    public void setWalkSpeed(float speed) {
        this.modifyAbilities(abilitiesTag -> (CompoundBinaryTag)abilitiesTag.putFloat("walkSpeed", speed / 2.0f));
    }

    public boolean getAllowFlight() {
        return this.compound.getCompound("abilities").getBoolean("mayfly");
    }

    public void setAllowFlight(boolean allow) {
        this.modifyAbilities(abilitiesTag -> (CompoundBinaryTag)abilitiesTag.putBoolean("mayfly", allow));
    }

    public void setLastDeathLocation(Location deathLoc) {
        CompoundBinaryTag compoundTag = this.compound.getCompound("LastDeathLocation");
        compoundTag = ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(compoundTag)).putIntArray("pos", new int[]{deathLoc.getBlockX(), deathLoc.getBlockY(), deathLoc.getBlockZ()})).putString("dimension", deathLoc.getWorld().getKey().toString())).build();
        this.compound = (CompoundBinaryTag)this.compound.put("LastDeathLocation", compoundTag);
        this.markModified();
    }
}

