/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.Strategy;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;

public class FakeBlockHelper {
    public static Field CHUNKDATA_BLOCK_ENTITIES = ReflectionHelper.getFields(ClientboundLevelChunkPacketData.class).getFirstOfType(List.class);
    public static MethodHandle CHUNKDATA_BLOCK_ENTITY_CONSTRUCTOR = ReflectionHelper.getConstructor(ClientboundLevelChunkPacketData.class.getDeclaredClasses()[0], Integer.TYPE, Integer.TYPE, TileEntityTypes.class, NBTTagCompound.class);
    public static MethodHandle CHUNKDATA_BUFFER_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(ClientboundLevelChunkPacketData.class, byte[].class);
    public static Class CHUNKDATA_BLOCKENTITYINFO_CLASS = ClientboundLevelChunkPacketData.class.getDeclaredClasses()[0];
    public static Field CHUNKDATA_BLOCKENTITYINFO_PACKEDXZ = ReflectionHelper.getFields(CHUNKDATA_BLOCKENTITYINFO_CLASS).get(ReflectionMappingsInfo.ClientboundLevelChunkPacketDataBlockEntityInfo_packedXZ);
    public static Field CHUNKDATA_BLOCKENTITYINFO_Y = ReflectionHelper.getFields(CHUNKDATA_BLOCKENTITYINFO_CLASS).get(ReflectionMappingsInfo.ClientboundLevelChunkPacketDataBlockEntityInfo_y);
    public static MethodHandle CHUNKPACKET_CHUNKDATA_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(ClientboundLevelChunkWithLightPacket.class, ClientboundLevelChunkPacketData.class);
    public static Constructor<?> PALETTEDCONTAINER_CTOR = Arrays.stream(DataPaletteBlock.class.getConstructors()).filter(c2 -> c2.getParameterCount() == 2).findFirst().get();
    public static Field PAPER_CHUNK_READY;
    public static boolean tryPaperPatch;

    public static IBlockData getNMSState(FakeBlock block) {
        return ((CraftBlockData)block.material.getModernData()).getState();
    }

    public static boolean anyBlocksInSection(List<FakeBlock> blocks, int y) {
        int minY = y << 4;
        int maxY = (y << 4) + 16;
        for (FakeBlock block : blocks) {
            int blockY = block.location.getBlockY();
            if (blockY < minY || blockY >= maxY) continue;
            return true;
        }
        return false;
    }

    public static void copyPacketPaperPatch(ClientboundLevelChunkWithLightPacket newPacket, ClientboundLevelChunkWithLightPacket oldPacket) {
        if (!Denizen.supportsPaper || !tryPaperPatch) {
            return;
        }
        try {
            if (PAPER_CHUNK_READY == null) {
                PAPER_CHUNK_READY = ReflectionHelper.getFields(ClientboundLevelChunkWithLightPacket.class).get("ready");
            }
        }
        catch (Throwable ex) {
            tryPaperPatch = false;
            Debug.echoError("Paper packet patch failed:");
            Debug.echoError(ex);
            return;
        }
        try {
            PAPER_CHUNK_READY.setBoolean(newPacket, true);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    public static ClientboundLevelChunkWithLightPacket handleMapChunkPacket(World world, ClientboundLevelChunkWithLightPacket originalPacket, int chunkX, int chunkZ, List<FakeBlock> blocks) {
        try {
            ClientboundLevelChunkWithLightPacket duplicateCorePacket = DenizenNetworkManagerImpl.copyPacket(originalPacket, ClientboundLevelChunkWithLightPacket.a);
            FakeBlockHelper.copyPacketPaperPatch(duplicateCorePacket, originalPacket);
            RegistryFriendlyByteBuf copier = new RegistryFriendlyByteBuf(Unpooled.buffer(), CraftRegistry.getMinecraftRegistry());
            originalPacket.f().a(copier);
            ClientboundLevelChunkPacketData packet = new ClientboundLevelChunkPacketData(copier, chunkX, chunkZ);
            PacketDataSerializer serial = originalPacket.f().a();
            PacketDataSerializer outputSerial = new PacketDataSerializer(Unpooled.buffer((int)serial.readableBytes()));
            ArrayList<Object> blockEntities = new ArrayList<Object>((List)CHUNKDATA_BLOCK_ENTITIES.get(originalPacket.f()));
            CHUNKDATA_BLOCK_ENTITIES.set(packet, blockEntities);
            block2: for (int i = 0; i < blockEntities.size(); ++i) {
                Object blockEnt = blockEntities.get(i);
                int xz = CHUNKDATA_BLOCKENTITYINFO_PACKEDXZ.getInt(blockEnt);
                int y = CHUNKDATA_BLOCKENTITYINFO_Y.getInt(blockEnt);
                int x = (chunkX << 4) + (xz >> 4 & 0xF);
                int z = (chunkZ << 4) + (xz & 0xF);
                for (FakeBlock block : blocks) {
                    LocationTag loc = block.location;
                    if (loc.getBlockX() != x || loc.getBlockY() != y || loc.getBlockZ() != z || block.material == null) continue;
                    TileEntity newBlockEnt = CraftBlockStates.createNewTileEntity((Material)block.material.getMaterial());
                    Object newData = CHUNKDATA_BLOCK_ENTITY_CONSTRUCTOR.invoke(xz, y, newBlockEnt.s(), newBlockEnt.a((HolderLookup.a)CraftRegistry.getMinecraftRegistry()));
                    blockEntities.set(i, newData);
                    continue block2;
                }
            }
            int worldMinY = world.getMinHeight();
            int worldMaxY = world.getMaxHeight();
            int minChunkY = worldMinY >> 4;
            int maxChunkY = worldMaxY >> 4;
            IRegistry biomeRegistry = ((CraftWorld)world).getHandle().J_().f(Registries.aS);
            for (int y = minChunkY; y < maxChunkY; ++y) {
                int blockCount = serial.readShort();
                DataPaletteBlock states = (DataPaletteBlock)PALETTEDCONTAINER_CTOR.newInstance(Blocks.a.m(), Strategy.a((Registry)Block.k));
                states.a(serial);
                DataPaletteBlock biomes = (DataPaletteBlock)PALETTEDCONTAINER_CTOR.newInstance(biomeRegistry.b(Biomes.b), Strategy.b((Registry)biomeRegistry));
                biomes.a(serial);
                if (FakeBlockHelper.anyBlocksInSection(blocks, y)) {
                    int minY = y << 4;
                    int maxY = (y << 4) + 16;
                    for (FakeBlock block : blocks) {
                        int blockY = block.location.getBlockY();
                        if (blockY < minY || blockY >= maxY || block.material == null) continue;
                        int blockX = block.location.getBlockX();
                        int blockZ = block.location.getBlockZ();
                        blockX -= (blockX >> 4) * 16;
                        blockY -= (blockY >> 4) * 16;
                        blockZ -= (blockZ >> 4) * 16;
                        IBlockData oldState = (IBlockData)states.a(blockX, blockY, blockZ);
                        IBlockData newState = FakeBlockHelper.getNMSState(block);
                        if (oldState.l() && !newState.l()) {
                            ++blockCount;
                        } else if (newState.l() && !oldState.l()) {
                            --blockCount;
                        }
                        states.c(blockX, blockY, blockZ, (Object)newState);
                    }
                }
                outputSerial.m(blockCount);
                states.b(outputSerial);
                biomes.b(outputSerial);
            }
            byte[] outputBytes = outputSerial.array();
            CHUNKDATA_BUFFER_SETTER.invoke(packet, outputBytes);
            CHUNKPACKET_CHUNKDATA_SETTER.invoke(duplicateCorePacket, packet);
            return duplicateCorePacket;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    static {
        tryPaperPatch = true;
    }
}

