/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.npc.traits.FishingTrait;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class FishCommand
extends AbstractCommand {
    public FishCommand() {
        this.setName("fish");
        this.setSyntax("fish [<location>] (catch:{none}/default/junk/treasure/fish) (stop) (chance:<#>)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("catch") && arg.matchesPrefix("catch") && arg.matchesEnum(FishingHelper.CatchType.class)) {
                scriptEntry.addObject("catch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("stop") && arg.matches("stop")) {
                scriptEntry.addObject("stop", new ElementTag(true));
                continue;
            }
            if (scriptEntry.hasObject("percent") || !arg.matchesPrefix("catchpercent", "percent", "chance", "c") || !arg.matchesInteger()) continue;
            scriptEntry.addObject("percent", arg.asElement());
        }
        if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("stop")) {
            throw new InvalidArgumentsException("Must specify a valid location!");
        }
        scriptEntry.defaultObject("catch", new ElementTag("NONE")).defaultObject("stop", new ElementTag(false)).defaultObject("percent", new ElementTag(65));
        if (!Utilities.entryHasNPC(scriptEntry) || !Utilities.getEntryNPC(scriptEntry).isSpawned()) {
            throw new InvalidArgumentsException("This command requires a linked and spawned NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag catchtype = scriptEntry.getElement("catch");
        ElementTag stop = scriptEntry.getElement("stop");
        ElementTag percent = scriptEntry.getElement("percent");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), location, catchtype, percent, stop);
        }
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        FishingTrait trait = npc.getFishingTrait();
        if (stop.asBoolean()) {
            trait.stopFishing();
            return;
        }
        npc.getEquipmentTrait().set(Equipment.EquipmentSlot.HAND, new ItemStack(Material.FISHING_ROD));
        trait.setCatchPercent(percent.asInt());
        trait.setCatchType(FishingHelper.CatchType.valueOf(catchtype.asString().toUpperCase()));
        trait.startFishing(location);
    }
}

