/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;

public class ProjectileLaunchedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag projectile;
    private LocationTag location;
    public ProjectileLaunchEvent event;
    public EntityTag shooter;

    public ProjectileLaunchedScriptEvent() {
        this.registerCouldMatcher("<entity> launched");
        this.registerSwitches("by");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(0, this.projectile)) {
            return false;
        }
        if (!path.tryObjectSwitch("by", this.shooter)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> {
                BukkitImplDeprecations.projectileLaunchedEntityContext.warn();
                yield this.projectile;
            }
            case "projectile" -> this.projectile;
            case "shooter" -> this.shooter.getDenizenObject();
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onProjectileLaunched(ProjectileLaunchEvent event) {
        Projectile entity = event.getEntity();
        EntityTag.rememberEntity((Entity)entity);
        this.event = event;
        this.projectile = new EntityTag((Entity)entity);
        this.location = this.projectile.getLocation();
        this.shooter = this.projectile.getShooter();
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)entity);
    }
}

