/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.entity.EntityLoadCrossbowEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EntityLoadCrossbowScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityLoadCrossbowEvent event;
    public EntityTag entity;

    public EntityLoadCrossbowScriptEvent() {
        this.registerCouldMatcher("<entity> loads crossbow");
        this.registerSwitches("crossbow");
        this.registerTextDetermination("keep_item", evt -> evt.event.setConsumeItem(false));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        if (!EntityLoadCrossbowScriptEvent.runWithCheck(path, new ItemTag(this.event.getCrossbow()), "crossbow")) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity.getDenizenObject();
            case "crossbow" -> new ItemTag(this.event.getCrossbow());
            case "hand" -> new ElementTag((Enum<?>)this.event.getHand());
            case "consumes" -> new ElementTag(this.event.shouldConsumeItem());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onLoadCrossbow(EntityLoadCrossbowEvent event) {
        this.event = event;
        this.entity = new EntityTag((Entity)event.getEntity());
        this.fire((Event)event);
    }
}

