/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.worldguard;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.depenizen.bukkit.bridges.WorldGuardBridge;
import com.denizenscript.depenizen.bukkit.objects.worldguard.WorldGuardRegionTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.World;

public class WorldGuardCuboidProperties
implements Property {
    public static final String[] handledTags = new String[]{"has_region", "regions"};
    public static final String[] handledMechs = new String[0];
    CuboidTag cuboid;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "WorldGuardCuboid";
    }

    public void adjust(Mechanism mechanism) {
    }

    public static boolean describes(ObjectTag cuboid) {
        return cuboid instanceof CuboidTag;
    }

    public static WorldGuardCuboidProperties getFrom(ObjectTag cuboid) {
        if (!WorldGuardCuboidProperties.describes(cuboid)) {
            return null;
        }
        return new WorldGuardCuboidProperties((CuboidTag)cuboid);
    }

    public WorldGuardCuboidProperties(CuboidTag cuboid) {
        this.cuboid = cuboid;
    }

    public ApplicableRegionSet getApplicableRegions() {
        WorldGuardPlugin worldGuard = (WorldGuardPlugin)WorldGuardBridge.instance.plugin;
        LocationTag low = this.cuboid.getLow(0);
        LocationTag high = this.cuboid.getHigh(0);
        BlockVector3 vecLow = BlockVector3.at((double)low.getX(), (double)low.getY(), (double)low.getZ());
        BlockVector3 vecHigh = BlockVector3.at((double)high.getX(), (double)high.getY(), (double)high.getZ());
        ProtectedCuboidRegion region = new ProtectedCuboidRegion("FAKE_REGION", vecLow, vecHigh);
        return WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)this.cuboid.getWorld().getWorld())).getApplicableRegions((ProtectedRegion)region);
    }

    public boolean hasRegion() {
        return this.getApplicableRegions().size() > 0;
    }

    public ListTag getRegions(World world) {
        ListTag regionList = new ListTag();
        for (ProtectedRegion protectedRegion : this.getApplicableRegions()) {
            regionList.addObject((ObjectTag)new WorldGuardRegionTag(protectedRegion, world));
        }
        return regionList;
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute.startsWith("has_region")) {
            return new ElementTag(this.hasRegion()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("regions")) {
            return this.getRegions(this.cuboid.getWorld().getWorld()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }
}

