/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.worldguard;

import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.depenizen.bukkit.objects.worldguard.WorldGuardRegionTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.World;

public class WorldGuardWorldProperties
implements Property {
    public static final String[] handledTags = new String[]{"list_regions", "has_region"};
    public static final String[] handledMechs = new String[0];
    World world;
    RegionManager manager;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "WorldGuardWorld";
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof WorldTag;
    }

    public static WorldGuardWorldProperties getFrom(ObjectTag object) {
        if (!WorldGuardWorldProperties.describes(object)) {
            return null;
        }
        return new WorldGuardWorldProperties((WorldTag)object);
    }

    public WorldGuardWorldProperties(WorldTag world) {
        this.world = world.getWorld();
        this.manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)this.world));
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute.startsWith("list_regions")) {
            ListTag regions = new ListTag();
            for (ProtectedRegion r : this.manager.getRegions().values()) {
                regions.addObject((ObjectTag)new WorldGuardRegionTag(r, this.world));
            }
            return regions.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_region") && attribute.hasParam()) {
            return new ElementTag(this.manager.hasRegion(attribute.getParam())).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
    }
}

