/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.towny;

import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.depenizen.bukkit.objects.towny.NationTag;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class TownTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    public Town town;
    private String prefix = "Town";
    public static ObjectTagProcessor<TownTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="town")
    public static TownTag valueOf(String string, TagContext context) {
        Town town;
        if (string.startsWith("town@")) {
            string = string.substring("town@".length());
        }
        if (string.length() == 36 && string.indexOf(45) >= 0) {
            try {
                Town town2;
                UUID uuid = UUID.fromString(string);
                if (uuid != null && (town2 = TownyUniverse.getInstance().getTown(uuid)) != null) {
                    return new TownTag(town2);
                }
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
        }
        if ((town = TownyUniverse.getInstance().getTown(string)) == null) {
            return null;
        }
        return new TownTag(town);
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("town@")) {
            return true;
        }
        return TownTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public TownTag(Town town) {
        this.town = town;
    }

    public static TownTag fromWorldCoord(WorldCoord coord) {
        if (coord == null) {
            return null;
        }
        try {
            return new TownTag(coord.getTownBlock().getTown());
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public static ListTag getPlayersFromResidents(Collection<Resident> residentCollection) {
        ListTag list = new ListTag();
        for (Resident resident : residentCollection) {
            OfflinePlayer pl;
            if (resident.getUUID() != null && (pl = Bukkit.getOfflinePlayer((UUID)resident.getUUID())).hasPlayedBefore()) {
                list.addObject((ObjectTag)new PlayerTag(pl));
                continue;
            }
            list.add(resident.getName());
        }
        return list;
    }

    public static CuboidTag getCuboid(World world, int townCoordX, int townCoordZ) {
        int x = townCoordX * Coord.getCellSize();
        int z = townCoordZ * Coord.getCellSize();
        return new CuboidTag((Location)new LocationTag(world, (double)x, (double)world.getMinHeight(), (double)z), (Location)new LocationTag(world, (double)(x + Coord.getCellSize() - 1), (double)world.getMaxHeight(), (double)(z + Coord.getCellSize() - 1)));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public TownTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "town@" + String.valueOf(this.town.getUUID());
    }

    public String identifySimple() {
        return this.identify();
    }

    public Town getTown() {
        return this.town;
    }

    public boolean equals(TownTag town) {
        return town.getTown().getUUID().equals(this.getTown().getUUID());
    }

    public String toString() {
        return this.identify();
    }

    public AbstractFlagTracker getFlagTracker() {
        if (DenizenCore.serverFlagMap.hasFlag("__depenizen_towny_nations." + this.town.getName()) && !DenizenCore.serverFlagMap.hasFlag("__depenizen_towny_towns_uuid." + String.valueOf(this.town.getUUID()))) {
            ObjectTag legacyValue = DenizenCore.serverFlagMap.getFlagValue("__depenizen_towny_nations." + this.town.getName());
            DenizenCore.serverFlagMap.setFlag("__depenizen_towny_towns_uuid." + String.valueOf(this.town.getUUID()), legacyValue, null);
            DenizenCore.serverFlagMap.setFlag("__depenizen_towny_nations." + this.town.getName(), null, null);
        }
        return new RedirectionFlagTracker((AbstractFlagTracker)DenizenCore.serverFlagMap, "__depenizen_towny_towns_uuid." + String.valueOf(this.town.getUUID()));
    }

    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void register() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ListTag.class, "assistants", (attribute, object) -> TownTag.getPlayersFromResidents(object.town.getRank("assistant")), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "balance", (attribute, object) -> new ElementTag(object.town.getAccount().getHoldingBalance()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "board", (attribute, object) -> new ElementTag(object.town.getBoard()), new String[0]);
        tagProcessor.registerTag(ListTag.class, ElementTag.class, "members_by_rank", (attribute, object, rankObj) -> TownTag.getPlayersFromResidents(object.town.getRank(rankObj.asString())), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_open", (attribute, object) -> new ElementTag(object.town.isOpen()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_public", (attribute, object) -> new ElementTag(object.town.isPublic()), new String[0]);
        tagProcessor.registerTag(PlayerTag.class, "mayor", (attribute, object) -> {
            OfflinePlayer pl;
            Resident mayor = object.town.getMayor();
            if (mayor.getUUID() != null && (pl = Bukkit.getOfflinePlayer((UUID)mayor.getUUID())).hasPlayedBefore()) {
                return new PlayerTag(pl);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.town.getName()), new String[0]);
        tagProcessor.registerTag(NationTag.class, "nation", (attribute, object) -> {
            try {
                return new NationTag(object.town.getNation());
            }
            catch (NotRegisteredException notRegisteredException) {
                return null;
            }
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "outlaws", (attribute, object) -> TownTag.getPlayersFromResidents(object.town.getOutlaws()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "player_count", (attribute, object) -> new ElementTag(object.town.getNumResidents()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "residents", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Resident resident : object.town.getResidents()) {
                OfflinePlayer pl;
                if (resident.getUUID() != null && (pl = Bukkit.getOfflinePlayer((UUID)resident.getUUID())).hasPlayedBefore()) {
                    list.addObject((ObjectTag)new PlayerTag(pl));
                    continue;
                }
                list.add(resident.getName());
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "size", (attribute, object) -> new ElementTag(object.town.getPurchasedBlocks()), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "spawn", (attribute, object) -> {
            try {
                return new LocationTag(object.town.getSpawn());
            }
            catch (TownyException townyException) {
                return null;
            }
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "tag", (attribute, object) -> new ElementTag(object.town.getTag()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "taxes", (attribute, object) -> new ElementTag(object.town.getTaxes()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "outposts", (attribute, object) -> {
            ListTag posts = new ListTag();
            for (Location p : object.town.getAllOutpostSpawns()) {
                posts.addObject((ObjectTag)new LocationTag(p));
            }
            return posts;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_explosions", (attribute, object) -> new ElementTag(object.town.isBANG()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_mobs", (attribute, object) -> new ElementTag(object.town.hasMobs()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_pvp", (attribute, object) -> new ElementTag(object.town.isPVP()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_firespread", (attribute, object) -> new ElementTag(object.town.isFire()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "has_taxpercent", (attribute, object) -> new ElementTag(object.town.isTaxPercentage()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "plot_object_group_names", (attribute, object) -> {
            ListTag output = new ListTag();
            if (!object.town.hasPlotGroups()) {
                return null;
            }
            for (PlotGroup group : object.town.getPlotGroups()) {
                output.add(group.getName());
            }
            return output;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "plots", (attribute, object) -> {
            ListTag output = new ListTag();
            for (TownBlock block : object.town.getTownBlocks()) {
                output.addObject((ObjectTag)new ChunkTag(new WorldTag(block.getWorld().getName()), block.getX(), block.getZ()));
            }
            return output;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "cuboids", (attribute, object) -> {
            ListTag output = new ListTag();
            for (TownBlock block : object.town.getTownBlocks()) {
                output.addObject((ObjectTag)TownTag.getCuboid(block.getWorldCoord().getBukkitWorld(), block.getX(), block.getZ()));
            }
            return output;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "plottax", (attribute, object) -> new ElementTag(object.town.getPlotTax()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "plotprice", (attribute, object) -> new ElementTag(object.town.getPlotPrice()), new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply properties to a Towny town!");
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("balance")) {
            ListTag input = (ListTag)mechanism.valueAsType(ListTag.class);
            if (input.size() != 2 || !ArgumentHelper.matchesDouble((String)input.get(0))) {
                mechanism.echoError("Invalid balance mech input.");
                return;
            }
            this.town.getAccount().setBalance(new ElementTag(input.get(0)).asDouble(), input.get(1));
        }
    }
}

