/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.worldguard;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.depenizen.bukkit.objects.worldguard.WorldGuardRegionTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.World;

public class WorldGuardCuboidExtensions {
    public static ApplicableRegionSet getApplicableRegions(CuboidTag cuboid) {
        LocationTag low = cuboid.getLow(0);
        LocationTag high = cuboid.getHigh(0);
        BlockVector3 vecLow = BlockVector3.at((double)low.getX(), (double)low.getY(), (double)low.getZ());
        BlockVector3 vecHigh = BlockVector3.at((double)high.getX(), (double)high.getY(), (double)high.getZ());
        ProtectedCuboidRegion region = new ProtectedCuboidRegion("FAKE_REGION", vecLow, vecHigh);
        return WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)cuboid.getWorld().getWorld())).getApplicableRegions((ProtectedRegion)region);
    }

    public static void register() {
        CuboidTag.tagProcessor.registerTag(ElementTag.class, "has_region", (attribute, area) -> new ElementTag(WorldGuardCuboidExtensions.getApplicableRegions(area).size() > 0), new String[0]);
        CuboidTag.tagProcessor.registerTag(ListTag.class, "regions", (attribute, area) -> {
            ListTag regionList = new ListTag();
            for (ProtectedRegion protectedRegion : WorldGuardCuboidExtensions.getApplicableRegions(area)) {
                regionList.addObject((ObjectTag)new WorldGuardRegionTag(protectedRegion, area.getWorld().getWorld()));
            }
            return regionList;
        }, new String[0]);
    }
}

