/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee.packets.in;

import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.BungeePacketIn;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeePlayerQuitsScriptEvent;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class PlayerQuitPacketIn
extends BungeePacketIn {
    @Override
    public String getName() {
        return "PlayerQuit";
    }

    @Override
    public void process(ByteBuf data) {
        if (data.readableBytes() < 12) {
            BungeeBridge.instance.handler.fail("Invalid PlayerQuitPacket (bytes available: " + data.readableBytes() + ")");
            return;
        }
        long mostSigBits = data.readLong();
        long leastSigBits = data.readLong();
        UUID uuid = new UUID(mostSigBits, leastSigBits);
        String name = this.readString(data, "name");
        String ip = this.readString(data, "ip");
        if (name == null || ip == null) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            BungeePlayerQuitsScriptEvent.instance.name = name;
            BungeePlayerQuitsScriptEvent.instance.uuid = uuid;
            BungeePlayerQuitsScriptEvent.instance.ip = ip;
            BungeePlayerQuitsScriptEvent.instance.fire();
        });
    }
}

