/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugSubmitter;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.bridges.ASkyBlockBridge;
import com.denizenscript.depenizen.bukkit.bridges.AreaShopBridge;
import com.denizenscript.depenizen.bukkit.bridges.AriKeysBridge;
import com.denizenscript.depenizen.bukkit.bridges.BetonQuestBridge;
import com.denizenscript.depenizen.bukkit.bridges.BigDoorsBridge;
import com.denizenscript.depenizen.bukkit.bridges.BossShopBridge;
import com.denizenscript.depenizen.bukkit.bridges.CoreProtectBridge;
import com.denizenscript.depenizen.bukkit.bridges.CrackShotBridge;
import com.denizenscript.depenizen.bukkit.bridges.EffectLibBridge;
import com.denizenscript.depenizen.bukkit.bridges.EssentialsBridge;
import com.denizenscript.depenizen.bukkit.bridges.FactionsBridge;
import com.denizenscript.depenizen.bukkit.bridges.GriefPreventionBridge;
import com.denizenscript.depenizen.bukkit.bridges.JobsBridge;
import com.denizenscript.depenizen.bukkit.bridges.LibsDisguisesBridge;
import com.denizenscript.depenizen.bukkit.bridges.LuckPermsBridge;
import com.denizenscript.depenizen.bukkit.bridges.MagicSpellsBridge;
import com.denizenscript.depenizen.bukkit.bridges.McMMOBridge;
import com.denizenscript.depenizen.bukkit.bridges.MobArenaBridge;
import com.denizenscript.depenizen.bukkit.bridges.MythicKeysBridge;
import com.denizenscript.depenizen.bukkit.bridges.MythicMobsBridge;
import com.denizenscript.depenizen.bukkit.bridges.NoCheatPlusBridge;
import com.denizenscript.depenizen.bukkit.bridges.NoteBlockAPIBridge;
import com.denizenscript.depenizen.bukkit.bridges.OpenTerrainGeneratorBridge;
import com.denizenscript.depenizen.bukkit.bridges.PVPArenaBridge;
import com.denizenscript.depenizen.bukkit.bridges.PVPStatsBridge;
import com.denizenscript.depenizen.bukkit.bridges.PlaceholderAPIBridge;
import com.denizenscript.depenizen.bukkit.bridges.PlayerPointsBridge;
import com.denizenscript.depenizen.bukkit.bridges.PlotSquaredBridge;
import com.denizenscript.depenizen.bukkit.bridges.QuestsBridge;
import com.denizenscript.depenizen.bukkit.bridges.ResidenceBridge;
import com.denizenscript.depenizen.bukkit.bridges.SentinelBridge;
import com.denizenscript.depenizen.bukkit.bridges.ShopkeepersBridge;
import com.denizenscript.depenizen.bukkit.bridges.SkillAPIBridge;
import com.denizenscript.depenizen.bukkit.bridges.TerrainControlBridge;
import com.denizenscript.depenizen.bukkit.bridges.TownyBridge;
import com.denizenscript.depenizen.bukkit.bridges.TownyChatBridge;
import com.denizenscript.depenizen.bukkit.bridges.VampireBridge;
import com.denizenscript.depenizen.bukkit.bridges.ViaVersionBridge;
import com.denizenscript.depenizen.bukkit.bridges.ViveCraftBridge;
import com.denizenscript.depenizen.bukkit.bridges.VotifierBridge;
import com.denizenscript.depenizen.bukkit.bridges.WorldEditBridge;
import com.denizenscript.depenizen.bukkit.bridges.WorldGuardBridge;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.clientizen.ClientizenBridge;
import com.denizenscript.depenizen.bukkit.utilities.BridgeLoadException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Depenizen
extends JavaPlugin {
    public static Depenizen instance;
    public HashMap<String, BridgeData> allBridges = new HashMap();
    public HashMap<String, Bridge> loadedBridges = new HashMap();

    public void onEnable() {
        Debug.log((String)"Depenizen loading...");
        this.saveDefaultConfig();
        instance = this;
        this.registerCoreBridges();
        for (Map.Entry<String, BridgeData> bridge : this.allBridges.entrySet()) {
            this.loadBridge(bridge.getKey(), bridge.getValue());
        }
        try {
            this.checkLoadBungeeBridge();
        }
        catch (Throwable ex) {
            Debug.echoError((String)"Cannot load Depenizen-Bungee bridge: Internal exception was thrown!");
            Debug.echoError((Throwable)ex);
        }
        this.checkLoadClientizenBridge();
        DebugSubmitter.debugHeaderLines.add(() -> "Depenizen Bridges loaded (" + this.loadedBridges.size() + "): " + String.valueOf(ChatColor.DARK_GREEN) + String.join((CharSequence)", ", this.loadedBridges.keySet()));
        Debug.log((String)("Depenizen loaded! <A>" + this.loadedBridges.size() + "<W> plugin bridge(s) loaded (of <A>" + this.allBridges.size() + "<W> available)"));
    }

    public void onDisable() {
        if (BungeeBridge.instance != null && BungeeBridge.instance.connected) {
            BungeeBridge.instance.onShutdown();
        }
        Denizen.getInstance().onDisable();
    }

    public void checkLoadBungeeBridge() {
        String bungeeServer = this.getConfig().getString("Bungee server address", "none");
        if (CoreUtilities.equalsIgnoreCase((String)bungeeServer, (String)"none")) {
            return;
        }
        new BungeeBridge().init(bungeeServer, this.getConfig().getInt("Bungee server port", 25565));
        Debug.log((String)"Loaded bungee bridge!");
    }

    public void checkLoadClientizenBridge() {
        if (this.getConfig().getBoolean("Clientizen.enabled")) {
            ClientizenBridge.init();
        }
    }

    public void loadBridge(String name, BridgeData bridgeData) {
        Bridge newBridge;
        Plugin plugin = Bukkit.getPluginManager().getPlugin(name);
        if (plugin == null) {
            return;
        }
        if (bridgeData.classCheck() != null) {
            try {
                Class.forName(bridgeData.classCheck());
            }
            catch (ClassNotFoundException e) {
                Debug.echoError((String)("Tried loading plugin bridge for '<Y>" + name + "<W>', but could not match class '<Y>" + bridgeData.classCheck() + "<W>'.\n<FORCE_ALIGN>This usually means you have a plugin with the same name as one supported by Depenizen, which should be reported to the developers of that plugin."));
                return;
            }
        }
        try {
            newBridge = bridgeData.creator().get();
        }
        catch (Throwable ex) {
            Debug.echoError((String)("Cannot load Depenizen bridge for '" + name + "': fundamental loading error:"));
            Debug.echoError((Throwable)ex);
            return;
        }
        newBridge.name = name;
        newBridge.plugin = plugin;
        try {
            newBridge.init();
        }
        catch (BridgeLoadException ex) {
            Debug.echoError((String)("Cannot load Depenizen bridge for '" + name + "': " + ex.getMessage()));
            return;
        }
        catch (Throwable ex) {
            Debug.echoError((String)("Cannot load Depenizen bridge for '" + name + "': Internal exception was thrown!"));
            Debug.echoError((Throwable)ex);
            return;
        }
        this.loadedBridges.put(name, newBridge);
        Debug.log((String)("Loaded bridge for '" + name + "'!"));
    }

    public void registerCoreBridges() {
        this.registerBridge("AreaShop", () -> new AreaShopBridge());
        this.registerBridge("AriKeys", () -> new AriKeysBridge());
        this.registerBridge("ASkyBlock", () -> new ASkyBlockBridge());
        this.registerBridge("BetonQuest", () -> new BetonQuestBridge());
        this.registerBridge("BigDoors", () -> new BigDoorsBridge());
        this.registerBridge("BossShopPro", () -> new BossShopBridge());
        this.registerBridge("CoreProtect", () -> new CoreProtectBridge());
        this.registerBridge("CrackShot", () -> new CrackShotBridge());
        this.registerBridge("EffectLib", () -> new EffectLibBridge());
        this.registerBridge("Essentials", () -> new EssentialsBridge());
        this.registerBridge("Factions", () -> new FactionsBridge());
        this.registerBridge("GriefPrevention", () -> new GriefPreventionBridge());
        this.registerBridge("Jobs", () -> new JobsBridge());
        this.registerBridge("LibsDisguises", () -> new LibsDisguisesBridge());
        this.registerBridge("LuckPerms", () -> new LuckPermsBridge());
        this.registerBridge("MagicSpells", () -> new MagicSpellsBridge());
        this.registerBridge("mcMMO", () -> new McMMOBridge());
        this.registerBridge("MobArena", () -> new MobArenaBridge());
        this.registerBridge("MythicKeysPlugin", () -> new MythicKeysBridge());
        this.registerBridge("MythicMobs", () -> new MythicMobsBridge());
        this.registerBridge("NoCheatPlus", () -> new NoCheatPlusBridge());
        this.registerBridge("NoteBlockAPI", () -> new NoteBlockAPIBridge());
        this.registerBridge("OpenTerrainGenerator", () -> new OpenTerrainGeneratorBridge());
        this.registerBridge("PlaceholderAPI", () -> new PlaceholderAPIBridge());
        this.registerBridge("PlayerPoints", () -> new PlayerPointsBridge());
        this.registerBridge("PlotSquared", () -> new PlotSquaredBridge());
        this.registerBridge("PVPArena", () -> new PVPArenaBridge());
        this.registerBridge("PVPStats", () -> new PVPStatsBridge());
        this.registerBridge("Quests", "me.pikamug.quests.Quests", () -> new QuestsBridge());
        this.registerBridge("Residence", () -> new ResidenceBridge());
        this.registerBridge("Sentinel", () -> new SentinelBridge());
        this.registerBridge("Shopkeepers", () -> new ShopkeepersBridge());
        this.registerBridge("SkillAPI", () -> new SkillAPIBridge());
        this.registerBridge("TerrainControl", () -> new TerrainControlBridge());
        this.registerBridge("Towny", () -> new TownyBridge());
        this.registerBridge("TownyChat", () -> new TownyChatBridge());
        this.registerBridge("Vampire", () -> new VampireBridge());
        this.registerBridge("ViaVersion", () -> new ViaVersionBridge());
        this.registerBridge("Vivecraft-Spigot-Extensions", () -> new ViveCraftBridge());
        this.registerBridge("Votifier", () -> new VotifierBridge());
        this.registerBridge("WorldEdit", () -> new WorldEditBridge());
        this.registerBridge("WorldGuard", () -> new WorldGuardBridge());
    }

    public void registerBridge(String name, Supplier<Bridge> bridgeSupplier) {
        this.registerBridge(name, null, bridgeSupplier);
    }

    public void registerBridge(String name, String classCheck, Supplier<Bridge> bridgeSupplier) {
        this.allBridges.put(name, new BridgeData(classCheck, bridgeSupplier));
    }

    public record BridgeData(String classCheck, Supplier<Bridge> creator) {
    }
}

