/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee;

import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;

public class NettyExceptionHandler
extends ChannelDuplexHandler {
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        BungeeBridge.runOnMainThread(() -> Debug.echoError((Throwable)cause));
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ctx.connect(remoteAddress, localAddress, promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                BungeeBridge.runOnMainThread(() -> Debug.echoError((Throwable)future.cause()));
            }
        })));
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write(msg, promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                BungeeBridge.runOnMainThread(() -> Debug.echoError((Throwable)future.cause()));
            }
        })));
    }
}

