/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.clientizen.commands;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.denizenscript.depenizen.bukkit.clientizen.ClientizenBridge;
import com.denizenscript.depenizen.bukkit.clientizen.network.NetworkManager;
import com.denizenscript.depenizen.bukkit.clientizen.network.packets.RunClientScriptPacketOut;
import java.util.HashMap;
import java.util.Map;

public class ClientRunCommand
extends AbstractCommand {
    public ClientRunCommand() {
        this.setName("clientrun");
        this.setSyntax("clientrun [<script>] (path:<name>) (def.<name>:<value>) (defmap:<map>)");
        this.setRequiredArguments(1, -1);
        this.allowedDynamicPrefixes = true;
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        MapTag defMap = new MapTag();
        for (Argument arg : scriptEntry) {
            if (arg.matchesPrefix("defmap") && arg.matchesArgumentType(MapTag.class)) {
                defMap.map.putAll(((MapTag)arg.asType(MapTag.class)).map);
                continue;
            }
            if (arg.hasPrefix() && arg.getPrefix().getRawValue().startsWith("def.")) {
                defMap.putObject(arg.getPrefix().getRawValue().substring("def.".length()), arg.object);
                continue;
            }
            if (!arg.hasPrefix() && arg.getRawValue().startsWith("def.") && arg.getRawValue().contains(":")) {
                String rawValue = arg.getRawValue();
                int colon = rawValue.indexOf(58);
                defMap.putObject(rawValue.substring("def.".length(), colon), (ObjectTag)new ElementTag(rawValue.substring(colon + 1)));
                continue;
            }
            if (!scriptEntry.hasObject("path") && arg.matchesPrefix("path")) {
                scriptEntry.addObject("path", (Object)arg.asElement().asString());
                continue;
            }
            if (!scriptEntry.hasObject("script")) {
                scriptEntry.addObject("script", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Must specify a script to run on the client.");
        }
        if (!defMap.map.isEmpty()) {
            scriptEntry.addObject("def_map", (Object)defMap);
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        PlayerTag clientizenPlayer = Utilities.getEntryPlayer((ScriptEntry)scriptEntry);
        if (clientizenPlayer == null) {
            throw new InvalidArgumentsRuntimeException("Must have a linked player who's client the script will be ran on, but none was found.");
        }
        if (!ClientizenBridge.clientizenPlayers.contains(clientizenPlayer.getUUID())) {
            throw new InvalidArgumentsRuntimeException("Player found, but isn't running Clientizen.");
        }
        String path = (String)scriptEntry.getObject("path");
        ElementTag script = scriptEntry.getElement("script");
        MapTag definitions = (MapTag)scriptEntry.getObjectTag("def_map");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{script, clientizenPlayer, path, definitions});
        }
        Map<String, String> stringDefMap = Map.of();
        if (definitions != null) {
            stringDefMap = new HashMap(definitions.size());
            for (Map.Entry entry : definitions.entrySet()) {
                stringDefMap.put(((StringHolder)entry.getKey()).str, ((ObjectTag)entry.getValue()).savable());
            }
        }
        NetworkManager.send(clientizenPlayer.getPlayerEntity(), new RunClientScriptPacketOut(script.asString(), path, stringDefMap));
    }
}

