/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.mythicmobs;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.bridges.MythicMobsBridge;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;

public class MythicSkillCommand
extends AbstractCommand {
    public MythicSkillCommand() {
        this.setName("mythicskill");
        this.setSyntax("mythicskill [<skillname>] [<location>|.../<entity>|...] (power:<#.#>) (casters:<entity>|...)");
        this.setRequiredArguments(2, 5);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("casters") && arg.matchesPrefix("casters") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("casters", (Object)((ListTag)arg.asType(ListTag.class)).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("skill") && MythicMobsBridge.skillExists(arg.asElement().asString())) {
                scriptEntry.addObject("skill", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entity_targets") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entity_targets", (Object)((ListTag)arg.asType(ListTag.class)).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("location_targets") && arg.matchesArgumentList(LocationTag.class)) {
                scriptEntry.addObject("location_targets", (Object)((ListTag)arg.asType(ListTag.class)).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("power") && arg.matchesFloat()) {
                scriptEntry.addObject("power", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("skill")) {
            throw new InvalidArgumentsException("Must specify a valid skill.");
        }
        if (scriptEntry.hasObject("entity_targets") && scriptEntry.hasObject("location_targets")) {
            throw new InvalidArgumentsException("Cannot have both entity and location targets.");
        }
        if (!scriptEntry.hasObject("casters")) {
            scriptEntry.defaultObject("casters", new Object[]{Utilities.entryDefaultEntityList((ScriptEntry)scriptEntry, (boolean)true)});
        }
        scriptEntry.defaultObject("power", new Object[]{new ElementTag(0)});
    }

    public void execute(ScriptEntry scriptEntry) {
        List casters = (List)scriptEntry.getObject("casters");
        ElementTag skill = (ElementTag)scriptEntry.getObjectTag("skill");
        List entity_targets = (List)scriptEntry.getObject("entity_targets");
        List location_targets = (List)scriptEntry.getObject("location_targets");
        ElementTag power = (ElementTag)scriptEntry.getObjectTag("power");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{MythicSkillCommand.db((String)"casters", (Object)casters), skill, MythicSkillCommand.db((String)"location_Targets", (Object)location_targets), MythicSkillCommand.db((String)"entity_targets", (Object)entity_targets), power});
        }
        ArrayList<Entity> entityTargets = null;
        ArrayList locationTargets = null;
        if (entity_targets != null) {
            entityTargets = new ArrayList<Entity>();
            for (EntityTag entity : entity_targets) {
                entityTargets.add(entity.getBukkitEntity());
            }
        } else {
            locationTargets = new ArrayList(location_targets);
        }
        for (EntityTag caster : casters) {
            MythicMobsBridge.getAPI().castSkill(caster.getBukkitEntity(), skill.asString(), caster.getBukkitEntity().getLocation(), entityTargets, locationTargets, power.asFloat());
        }
    }
}

