/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.griefprevention;

import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Chunk;
import org.bukkit.Location;

public class GriefPreventionClaimTag
implements ObjectTag,
Adjustable,
FlaggableObject {
    static DataStore dataStore = GriefPrevention.instance.dataStore;
    private String prefix;
    Claim claim;
    public static ObjectTagProcessor<GriefPreventionClaimTag> tagProcessor = new ObjectTagProcessor();

    public static boolean matches(String id) {
        return GriefPreventionClaimTag.valueOf(id) != null;
    }

    public static GriefPreventionClaimTag valueOf(String id) {
        return GriefPreventionClaimTag.valueOf(id, null);
    }

    @Fetchable(value="gpclaim")
    public static GriefPreventionClaimTag valueOf(String id, TagContext context) {
        long claimID;
        id = id.replace("gpclaim@", "");
        try {
            claimID = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Claim claim = dataStore.getClaim(claimID);
        if (claim == null) {
            return null;
        }
        return new GriefPreventionClaimTag(claim);
    }

    public GriefPreventionClaimTag(Claim claim) {
        this.claim = claim;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "gpclaim@" + this.claim.getID();
    }

    public String toString() {
        return this.identify();
    }

    public AbstractFlagTracker getFlagTracker() {
        return new RedirectionFlagTracker((AbstractFlagTracker)DenizenCore.serverFlagMap, "__depenizen_gp_claims_id." + this.claim.getID());
    }

    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public String simple() {
        return String.valueOf(this.claim.getID());
    }

    public String identifySimple() {
        return this.identify();
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public static void register() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "id", (attribute, object) -> new ElementTag(object.claim.getID().longValue()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "managers", (attribute, object) -> {
            ListTag managers = new ListTag();
            for (String manager : object.claim.managers) {
                managers.addObject((ObjectTag)new PlayerTag(UUID.fromString(manager)));
            }
            return managers;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "trusted", (attribute, object) -> {
            ListTag trusted = new ListTag();
            ArrayList b = new ArrayList();
            object.claim.getPermissions(b, new ArrayList(), new ArrayList(), new ArrayList());
            for (String trust : b) {
                trusted.addObject((ObjectTag)new PlayerTag(UUID.fromString(trust)));
            }
            return trusted;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "builders", (attribute, object) -> {
            ListTag trusted = new ListTag();
            ArrayList b = new ArrayList();
            object.claim.getPermissions(b, new ArrayList(), new ArrayList(), new ArrayList());
            for (String trust : b) {
                trusted.addObject((ObjectTag)new PlayerTag(UUID.fromString(trust)));
            }
            return trusted;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "containers", (attribute, object) -> {
            ListTag trusted = new ListTag();
            ArrayList c = new ArrayList();
            object.claim.getPermissions(new ArrayList(), c, new ArrayList(), new ArrayList());
            for (String container : c) {
                trusted.addObject((ObjectTag)new PlayerTag(UUID.fromString(container)));
            }
            return trusted;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "accessors", (attribute, object) -> {
            ListTag trusted = new ListTag();
            ArrayList a = new ArrayList();
            object.claim.getPermissions(new ArrayList(), new ArrayList(), a, new ArrayList());
            for (String access : a) {
                trusted.addObject((ObjectTag)new PlayerTag(UUID.fromString(access)));
            }
            return trusted;
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "owner", (attribute, object) -> {
            if (object.claim.isAdminClaim()) {
                return new ElementTag("Admin");
            }
            return new PlayerTag(object.claim.ownerID);
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "cuboid", (attribute, object) -> {
            LocationTag lower = new LocationTag(object.claim.getLesserBoundaryCorner());
            LocationTag upper = new LocationTag(object.claim.getGreaterBoundaryCorner());
            upper.setY((double)upper.getWorld().getMaxHeight());
            return new CuboidTag((Location)lower, (Location)upper);
        }, new String[0]);
        tagProcessor.registerTag(WorldTag.class, "world", (attribute, object) -> new WorldTag(object.claim.getLesserBoundaryCorner().getWorld()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_adminclaim", (attribute, object) -> new ElementTag(object.claim.isAdminClaim()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "chunks", (attribute, object) -> {
            ListTag chunks = new ListTag();
            for (Chunk chunk : object.claim.getChunks()) {
                chunks.addObject((ObjectTag)new ChunkTag(chunk));
            }
            return chunks;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "can_siege", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            PlayerTag defender = (PlayerTag)attribute.paramAsType(PlayerTag.class);
            if (defender == null || defender.getPlayerEntity() == null) {
                return null;
            }
            return new ElementTag(object.claim.canSiege(defender.getPlayerEntity()));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_sieged", (attribute, object) -> new ElementTag(object.claim.siegeData != null), new String[0]);
    }

    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply Properties to a GriefPreventionClaim!");
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("owner")) {
            try {
                if (PlayerTag.matches((String)mechanism.getValue().asString())) {
                    PlayerTag player = (PlayerTag)mechanism.valueAsType(PlayerTag.class);
                    dataStore.changeClaimOwner(this.claim, player.getUUID());
                } else if (CoreUtilities.equalsIgnoreCase((String)mechanism.getValue().asString(), (String)"admin")) {
                    dataStore.changeClaimOwner(this.claim, null);
                }
            }
            catch (Exception e) {
                mechanism.echoError("Unable to transfer ownership of claim: " + this.identify() + ".");
            }
        }
        if (mechanism.matches("depth") && mechanism.requireInteger()) {
            dataStore.extendClaim(this.claim, mechanism.getValue().asInt());
        }
        for (Property property : PropertyParser.getProperties((ObjectTag)this)) {
            property.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            break;
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

