/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.quests;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.depenizen.bukkit.bridges.QuestsBridge;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;

public class QuestsPlayerProperties
implements Property {
    public static final String[] handledTags = new String[]{"quests"};
    public static final String[] handledMechs = new String[0];
    PlayerTag player;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "QuestsPlayer";
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof PlayerTag;
    }

    public static QuestsPlayerProperties getFrom(ObjectTag object) {
        if (!QuestsPlayerProperties.describes(object)) {
            return null;
        }
        return new QuestsPlayerProperties((PlayerTag)object);
    }

    public QuestsPlayerProperties(PlayerTag player) {
        this.player = player;
    }

    public Quester getQuester() {
        BukkitQuestsPlugin quests = (BukkitQuestsPlugin)QuestsBridge.instance.plugin;
        return quests.getQuester(this.player.getUUID());
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("quests")) {
            if ((attribute = attribute.fulfill(1)).startsWith("points")) {
                if (this.getQuester().getBaseData().contains("quest-points")) {
                    return new ElementTag(this.getQuester().getBaseData().getInt("quest-points")).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag("0").getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("completed_ids")) {
                ListTag list = new ListTag(this.getQuester().getCompletedQuests().stream().map(Quest::getId));
                return list.getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("completed_names")) {
                ListTag list = new ListTag(this.getQuester().getCompletedQuests().stream().map(Quest::getName));
                return list.getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("active_ids")) {
                ListTag list = new ListTag(this.getQuester().getCurrentQuests().keySet().stream().map(Quest::getId));
                return list.getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("active_names")) {
                ListTag list = new ListTag(this.getQuester().getCurrentQuests().keySet().stream().map(Quest::getName));
                return list.getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("completed")) {
                return new ElementTag(this.getQuester().getCompletedQuests().size()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("active")) {
                return new ElementTag(this.getQuester().getCurrentQuests().size()).getObjectAttribute(attribute.fulfill(1));
            }
            return null;
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
    }
}

