/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.worldguard;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.depenizen.bukkit.objects.worldguard.WorldGuardRegionTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Set;
import org.bukkit.Location;

public class WorldGuardLocationExtensions {
    public static Set<ProtectedRegion> getApplicableRegions(LocationTag loc) {
        return WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)loc)).getRegions();
    }

    public static void register() {
        LocationTag.tagProcessor.registerTag(ElementTag.class, "in_region", (attribute, loc) -> {
            Set<ProtectedRegion> queryRegions = WorldGuardLocationExtensions.getApplicableRegions(loc);
            if (attribute.hasParam()) {
                ListTag regions = (ListTag)attribute.paramAsType(ListTag.class);
                for (ProtectedRegion region : queryRegions) {
                    for (String id : regions) {
                        if (!id.equalsIgnoreCase(region.getId())) continue;
                        return new ElementTag(true);
                    }
                }
                return new ElementTag(false);
            }
            return new ElementTag(!queryRegions.isEmpty());
        }, new String[0]);
        LocationTag.tagProcessor.registerTag(ListTag.class, "regions", (attribute, loc) -> {
            Set<ProtectedRegion> queryRegions = WorldGuardLocationExtensions.getApplicableRegions(loc);
            ListTag regions = new ListTag(queryRegions.size());
            for (ProtectedRegion region : queryRegions) {
                regions.addObject((ObjectTag)new WorldGuardRegionTag(region, loc.getWorld()));
            }
            return regions;
        }, new String[0]);
    }
}

