/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.Depenizen;
import java.util.concurrent.Future;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class PlaceholderAPIBridge
extends Bridge {
    @Override
    public void init() {
        if (!new PlaceholderHook().register()) {
            Debug.echoError((String)"Failed to register placeholder for identifier 'denizen'! Denizen PlaceholderAPI placeholders will not function.");
        }
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                PlaceholderAPIBridge.this.tagEvent(event);
            }
        }, (String[])new String[]{"placeholder"});
    }

    public void tagEvent(ReplaceableTagEvent event) {
        OfflinePlayer player;
        Attribute attribute = event.getAttributes();
        String placeholder = attribute.getParam();
        if (CoreUtilities.toLowerCase((String)placeholder).startsWith("denizen_")) {
            Debug.echoError((String)"Cannot use <placeholder[]> tags with 'denizen' prefix!");
            return;
        }
        attribute = attribute.fulfill(1);
        OfflinePlayer offlinePlayer = player = ((BukkitTagContext)attribute.context).player != null ? ((BukkitTagContext)attribute.context).player.getOfflinePlayer() : null;
        if (attribute.matches("player") && attribute.hasParam() && attribute.getParamObject().canBeType(PlayerTag.class)) {
            player = ((PlayerTag)attribute.paramAsType(PlayerTag.class)).getOfflinePlayer();
            attribute.fulfill(1);
        }
        event.setReplacedObject(new ElementTag(PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)("%" + placeholder + "%"))).getObjectAttribute(attribute));
    }

    private static class PlaceholderHook
    extends PlaceholderExpansion {
        private PlaceholderHook() {
        }

        public boolean canRegister() {
            return true;
        }

        public boolean persist() {
            return true;
        }

        public String getAuthor() {
            return "The DenizenScript Team";
        }

        public String getIdentifier() {
            return "denizen";
        }

        public String getVersion() {
            return "2.0.0";
        }

        public String onRequest(OfflinePlayer player, String identifier) {
            if (!DenizenCore.isMainThread()) {
                if (Settings.allowAsyncPassThrough) {
                    try {
                        Future future = Bukkit.getScheduler().callSyncMethod((Plugin)Depenizen.instance, () -> this.onRequest(player, identifier));
                        return (String)future.get();
                    }
                    catch (Throwable ex) {
                        Debug.echoError((Throwable)ex);
                        return null;
                    }
                }
                Debug.echoError((String)"Warning: PlaceholderAPI from wrong thread, blocked. Inform the developer of whatever plugin tried to read Placeholder data that it is forbidden to do so async. You can use config option 'Scripts.Economy.Pass async to main thread' to enable dangerous access.");
                try {
                    throw new RuntimeException("Stack reference");
                }
                catch (RuntimeException ex) {
                    Debug.echoError((Throwable)ex);
                    return "WARNING-ILLEGAL-ASYNC-ACCESS";
                }
            }
            return TagManager.tag((String)identifier, (TagContext)new BukkitTagContext(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player), null, null, false, null));
        }
    }
}

