/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.luckperms;

import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.depenizen.bukkit.bridges.LuckPermsBridge;
import java.util.OptionalInt;
import net.luckperms.api.model.group.Group;

public class LuckPermsGroupTag
implements ObjectTag {
    Group group;
    String prefix = "LuckPermsGroup";
    public static ObjectTagProcessor<LuckPermsGroupTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="luckpermsgroup")
    public static LuckPermsGroupTag valueOf(String string, TagContext context) {
        Group group;
        if (string.startsWith("luckpermsgroup@")) {
            string = string.substring("luckpermsgroup@".length());
        }
        if ((group = LuckPermsBridge.luckPermsInstance.getGroupManager().getGroup(string)) == null) {
            return null;
        }
        return new LuckPermsGroupTag(group);
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("luckpermsgroup@")) {
            return true;
        }
        return LuckPermsBridge.luckPermsInstance.getGroupManager().isLoaded(arg);
    }

    public LuckPermsGroupTag(Group group) {
        this.group = group;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "luckpermsgroup@" + this.group.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public Group getGroup() {
        return this.group;
    }

    public static void register() {
        tagProcessor.registerStaticTag(ElementTag.class, "group_name", (attribute, object) -> new ElementTag(object.getGroup().getName(), true), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "group_prefix", (attribute, object) -> {
            String prefix = object.getGroup().getCachedData().getMetaData().getPrefix();
            return prefix != null ? new ElementTag(prefix, true) : null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "group_suffix", (attribute, object) -> {
            String suffix = object.getGroup().getCachedData().getMetaData().getSuffix();
            return suffix != null ? new ElementTag(suffix, true) : null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "group_weight", (attribute, object) -> {
            OptionalInt weight = object.getGroup().getWeight();
            return weight.isPresent() ? new ElementTag(weight.getAsInt()) : null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, ElementTag.class, "has_permission", (attribute, object, p) -> new ElementTag(object.getGroup().getCachedData().getPermissionData().checkPermission(p.asString()).asBoolean()), new String[0]);
    }
}

