/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.Arrays;
import java.util.HashSet;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.utilities.SentinelAPIBreakageFix;

public class SentinelTarget {
    public static SentinelTarget NPCS = new SentinelTarget(new EntityType[0], "NPC");
    public static SentinelTarget OWNER = new SentinelTarget(new EntityType[0], "OWNER");
    public static SentinelTarget PLAYERS = new SentinelTarget(new EntityType[]{EntityType.PLAYER}, "PLAYER");
    public static HashSet<EntityType> NATIVE_COMBAT_CAPABLE_TYPES = new HashSet<EntityType>(Arrays.asList(EntityType.ZOMBIE, EntityType.SKELETON));
    public static SentinelTarget PIGS = new SentinelTarget(new EntityType[]{EntityType.PIG}, "PIG");
    public static SentinelTarget OCELOTS = new SentinelTarget(new EntityType[]{EntityType.OCELOT}, "OCELOT", "CAT");
    public static SentinelTarget COWS = new SentinelTarget(new EntityType[]{EntityType.COW}, "COW");
    public static SentinelTarget RABBITS = new SentinelTarget(new EntityType[]{EntityType.RABBIT}, "RABBIT", "BUNNY", "BUNNIE");
    public static SentinelTarget SHEEP = new SentinelTarget(new EntityType[]{EntityType.SHEEP}, "SHEEP");
    public static SentinelTarget CHICKENS = new SentinelTarget(new EntityType[]{EntityType.CHICKEN}, "CHICKEN", "DUCK");
    public static SentinelTarget HORSES = new SentinelTarget(new EntityType[]{EntityType.HORSE}, "HORSE");
    public static SentinelTarget MUSHROOM_COW = new SentinelTarget(new EntityType[]{SentinelAPIBreakageFix.ENTITY_TYPE_MUSHROOM_COW}, "MUSHROOM_COW", "MUSHROOMCOW", "MOOSHROOM");
    public static SentinelTarget IRON_GOLEMS = new SentinelTarget(new EntityType[]{EntityType.IRON_GOLEM}, "IRON_GOLEM", "IRONGOLEM");
    public static SentinelTarget SQUIDS = new SentinelTarget(new EntityType[]{EntityType.SQUID}, "SQUID");
    public static SentinelTarget VILLAGER = new SentinelTarget(new EntityType[]{EntityType.VILLAGER}, "VILLAGER");
    public static SentinelTarget WOLVES = new SentinelTarget(new EntityType[]{EntityType.WOLF}, "WOLF", "WOLVE");
    public static SentinelTarget SNOWMEN = new SentinelTarget(new EntityType[]{SentinelAPIBreakageFix.ENTITY_TYPE_SNOWMAN}, "SNOWMAN", "SNOWMEN");
    public static SentinelTarget WITCHES = new SentinelTarget(new EntityType[]{EntityType.WITCH}, "WITCH");
    public static SentinelTarget GUARDIANS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN}, "GUARDIAN");
    public static SentinelTarget CREERERS = new SentinelTarget(new EntityType[]{EntityType.CREEPER}, "CREEPER");
    public static SentinelTarget SKELETONS = new SentinelTarget(new EntityType[]{EntityType.SKELETON}, "SKELETON");
    public static SentinelTarget ZOMBIES = new SentinelTarget(new EntityType[]{EntityType.ZOMBIE}, "ZOMBIE");
    public static SentinelTarget MAGMA_CUBES = new SentinelTarget(new EntityType[]{EntityType.MAGMA_CUBE}, "MAGMA_CUBE", "MAGMACUBE");
    public static SentinelTarget SILVERFISH = new SentinelTarget(new EntityType[]{EntityType.SILVERFISH}, "SILVERFISH", "SILVER_FISH", "SILVERFISHE", "SILVER_FISHE");
    public static SentinelTarget BATS = new SentinelTarget(new EntityType[]{EntityType.BAT}, "BAT");
    public static SentinelTarget BLAZES = new SentinelTarget(new EntityType[]{EntityType.BLAZE}, "BLAZE");
    public static SentinelTarget GHASTS = new SentinelTarget(new EntityType[]{EntityType.GHAST}, "GHAST");
    public static SentinelTarget GIANTS = new SentinelTarget(new EntityType[]{EntityType.GIANT}, "GIANT");
    public static SentinelTarget SLIMES = new SentinelTarget(new EntityType[]{EntityType.SLIME}, "SLIME");
    public static SentinelTarget SPIDERS = new SentinelTarget(new EntityType[]{EntityType.SPIDER}, "SPIDER");
    public static SentinelTarget CAVE_SPIDERS = new SentinelTarget(new EntityType[]{EntityType.CAVE_SPIDER}, "CAVE_SPIDER", "CAVESPIDER");
    public static SentinelTarget ENDERMEN = new SentinelTarget(new EntityType[]{EntityType.ENDERMAN}, "ENDERMAN", "ENDER_MAN", "ENDERMEN", "ENDER_MEN");
    public static SentinelTarget ENDERMITES = new SentinelTarget(new EntityType[]{EntityType.ENDERMITE}, "ENDERMITE", "ENDER_MITE");
    public static SentinelTarget WITHERS = new SentinelTarget(new EntityType[]{EntityType.WITHER}, "WITHER");
    public static SentinelTarget ENDERDRAGONS = new SentinelTarget(new EntityType[]{EntityType.ENDER_DRAGON}, "ENDERDRAGON", "ENDER_DRAGON");
    public static SentinelTarget ARMOR_STAND = new SentinelTarget(new EntityType[]{EntityType.ARMOR_STAND}, "ARMORSTAND", "ARMOR_STAND");
    public static SentinelTarget SHULKERS;
    public static SentinelTarget POLAR_BEARS;
    public static SentinelTarget VEXES;
    public static SentinelTarget DONKEYS;
    public static SentinelTarget LLAMAS;
    public static SentinelTarget MULES;
    public static SentinelTarget HUSKS;
    public static SentinelTarget ELDER_GUARDIANS;
    public static SentinelTarget EVOKERS;
    public static SentinelTarget SKELETON_HORSES;
    public static SentinelTarget STRAYS;
    public static SentinelTarget ZOMBIE_VILLAGERS;
    public static SentinelTarget ZOMBIE_HORSES;
    public static SentinelTarget WITHER_SKELETONS;
    public static SentinelTarget VINDICATORS;
    public static SentinelTarget PARROTS;
    public static SentinelTarget ILLUSIONERS;
    public static SentinelTarget DOLPHINS;
    public static SentinelTarget DROWNED;
    public static SentinelTarget COD;
    public static SentinelTarget SALMON;
    public static SentinelTarget PUFFERFISH;
    public static SentinelTarget TROPICAL_FISH;
    public static SentinelTarget PHANTOMS;
    public static SentinelTarget TURTLES;
    public static SentinelTarget FISH;
    public static SentinelTarget RAVAGERS;
    public static SentinelTarget PILLAGERS;
    public static SentinelTarget CATS;
    public static SentinelTarget PANDAS;
    public static SentinelTarget TRADER_LLAMAS;
    public static SentinelTarget WANDERING_TRADERS;
    public static SentinelTarget FOXES;
    public static SentinelTarget BEES;
    public static SentinelTarget ZOMBIE_PIGMEN;
    public static SentinelTarget HOGLINS;
    public static SentinelTarget PIGLINS;
    public static SentinelTarget STRIDERS;
    public static SentinelTarget ZOGLINS;
    public static SentinelTarget ZOMBIFIED_PIGLINS;
    public static SentinelTarget PIGLIN_BRUTE;
    public static SentinelTarget TADPOLES;
    public static SentinelTarget FROGS;
    public static SentinelTarget ALLAYS;
    public static SentinelTarget WARDENS;
    public static SentinelTarget CAMELS;
    public static SentinelTarget SNIFFERS;
    public static SentinelTarget ARMADILLOS;
    public static SentinelTarget BOGGEDS;
    public static SentinelTarget BREEZES;
    public static SentinelTarget PASSIVE_MOBS;
    public static SentinelTarget MONSTERS;
    public static SentinelTarget MOBS;
    public String[] names;
    public HashSet<EntityType> types;

    public static HashSet<SentinelTarget> forEntityType(EntityType type) {
        return SentinelPlugin.entityToTargets.get(type);
    }

    public static SentinelTarget forName(String name) {
        return SentinelPlugin.targetOptions.get(name.toUpperCase());
    }

    public String name() {
        return this.names[0];
    }

    public SentinelTarget(EntityType[] types, String ... names) {
        this.names = names;
        this.types = new HashSet<EntityType>(Arrays.asList(types));
        for (String string : names) {
            SentinelPlugin.targetOptions.put(string, this);
            SentinelPlugin.targetOptions.put(string + "S", this);
        }
        for (String string : types) {
            SentinelPlugin.entityToTargets.get(string).add(this);
        }
    }

    public boolean isTarget(LivingEntity entity) {
        return this.isTarget(entity, null);
    }

    public boolean isTarget(LivingEntity entity, SentinelTrait sentinel) {
        if (this.types.contains(entity.getType())) {
            return true;
        }
        if (this == NPCS && CitizensAPI.getNPCRegistry().isNPC((Entity)entity)) {
            return true;
        }
        return this == OWNER && sentinel != null && SentinelUtilities.uuidEquals(entity.getUniqueId(), ((Owner)sentinel.getNPC().getOrAddTrait(Owner.class)).getOwnerId());
    }
}

