/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.utilities.SentinelNMSHelper;
import org.mcmonkey.sentinel.utilities.VelocityTracker;

public class SentinelEventHandler
implements Listener {
    public static HashMap<UUID, TrackedKillToBlock> killStatsToBlock = new HashMap();
    public static final String InvPrefix = ChatColor.GREEN + "Sentinel ";

    private ArrayList<SentinelTrait> cleanCurrentList() {
        return SentinelPlugin.instance.cleanCurrentList();
    }

    @EventHandler
    public void onEntityExplodes(EntityExplodeEvent event) {
        SentinelTrait sourceSentinel;
        ProjectileSource source;
        if (event.isCancelled()) {
            return;
        }
        if (!SentinelPlugin.instance.preventExplosionBlockDamage) {
            return;
        }
        if (event.getEntity() instanceof Projectile && (source = ((Projectile)event.getEntity()).getShooter()) instanceof Entity && (sourceSentinel = SentinelUtilities.tryGetSentinel((Entity)source)) != null) {
            event.blockList().clear();
        }
    }

    @EventHandler
    public void onBlockIgnites(BlockIgniteEvent event) {
        SentinelTrait sourceSentinel;
        ProjectileSource source;
        if (event.isCancelled()) {
            return;
        }
        if (!SentinelPlugin.instance.preventExplosionBlockDamage) {
            return;
        }
        if (event.getIgnitingEntity() instanceof Projectile && (source = ((Projectile)event.getIgnitingEntity()).getShooter()) instanceof Entity && (sourceSentinel = SentinelUtilities.tryGetSentinel((Entity)source)) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityCombusts(EntityCombustEvent event) {
        if (event instanceof EntityCombustByEntityEvent || event instanceof EntityCombustByBlockEvent) {
            return;
        }
        if (!SentinelPlugin.instance.blockSunburn) {
            return;
        }
        if (SentinelUtilities.tryGetSentinel(event.getEntity()) == null) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onProjectileHitsBlock(ProjectileHitEvent event) {
        if (SentinelPlugin.instance.arrowCleanupTime <= 0) {
            return;
        }
        final Projectile projectile = event.getEntity();
        ProjectileSource source = projectile.getShooter();
        if (!(source instanceof Entity)) {
            return;
        }
        SentinelTrait sentinel = SentinelUtilities.tryGetSentinel((Entity)source);
        if (sentinel == null) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, new Runnable(){

            @Override
            public void run() {
                if (projectile.isValid()) {
                    projectile.remove();
                }
            }
        }, (long)SentinelPlugin.instance.arrowCleanupTime);
    }

    @EventHandler
    public void onAsyncPlayerChat(final AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, new Runnable(){

            @Override
            public void run() {
                if (!event.getPlayer().isOnline()) {
                    return;
                }
                for (SentinelTrait sentinel : SentinelEventHandler.this.cleanCurrentList()) {
                    if (sentinel.allTargets.isEventTarget(sentinel, event)) {
                        sentinel.targetingHelper.addTarget(event.getPlayer().getUniqueId());
                    }
                    if (!sentinel.allAvoids.isEventTarget(sentinel, event)) continue;
                    sentinel.targetingHelper.addAvoid(event.getPlayer().getUniqueId());
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.LOW)
    public void whenAttacksAreHappening(EntityDamageByEntityEvent event) {
        SentinelTrait shooter;
        ProjectileSource source;
        if (event.isCancelled()) {
            return;
        }
        UUID victimUuid = event.getEntity().getUniqueId();
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            sentinel.whenSomethingMightDie(victimUuid);
        }
        SentinelTrait victim = SentinelUtilities.tryGetSentinel(event.getEntity());
        SentinelTrait attacker = SentinelUtilities.tryGetSentinel(event.getDamager());
        if (victim != null) {
            if (attacker != null && victim.getNPC().getId() == attacker.getNPC().getId()) {
                event.setCancelled(true);
                return;
            }
            victim.whenAttacksAreHappeningToMe(event);
        }
        if (attacker != null) {
            attacker.whenAttacksAreHappeningFromMe(event);
        }
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof Entity && (shooter = SentinelUtilities.tryGetSentinel((Entity)source)) != null) {
            shooter.whenAttacksAreHappeningFromMyArrow(event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void whenEntitiesAreHurt(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        SentinelTrait victim = SentinelUtilities.tryGetSentinel(event.getEntity());
        if (victim != null) {
            victim.whenImHurt(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void whenAttacksHappened(EntityDamageByEntityEvent event) {
        ProjectileSource source;
        if (event.isCancelled()) {
            return;
        }
        Entity damager = event.getDamager();
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof Entity) {
            damager = (Entity)source;
        }
        SentinelTrait victim = SentinelUtilities.tryGetSentinel(event.getEntity());
        SentinelTrait attacker = SentinelUtilities.tryGetSentinel(damager);
        if (attacker != null) {
            if (!(event.getEntity() instanceof LivingEntity)) {
                event.setCancelled(true);
                return;
            }
            if (victim != null && victim.getNPC().getId() == attacker.getNPC().getId()) {
                event.setCancelled(true);
                return;
            }
            attacker.whenAttacksHappened(event);
        }
        if (victim != null) {
            victim.whenAttacksHappened(event);
        }
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            UUID guarding = sentinel.getGuarding();
            if (guarding == null || !SentinelUtilities.uuidEquals(event.getEntity().getUniqueId(), guarding)) continue;
            sentinel.whenAttacksHappened(event);
        }
        if (damager instanceof LivingEntity) {
            LivingEntity damagerLiving = (LivingEntity)damager;
            for (SentinelTrait sentinel : this.cleanCurrentList()) {
                if (sentinel.allTargets.isEventTarget(event, sentinel) && sentinel.targetingHelper.canSee(damagerLiving) && !sentinel.targetingHelper.isIgnored(damagerLiving)) {
                    sentinel.targetingHelper.addTarget(damager.getUniqueId());
                }
                if (!sentinel.allAvoids.isEventTarget(event, sentinel) || !sentinel.targetingHelper.canSee(damagerLiving) || sentinel.targetingHelper.isIgnored(damagerLiving)) continue;
                sentinel.targetingHelper.addAvoid(damager.getUniqueId());
            }
        }
        if (event.getEntity() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            for (SentinelTrait sentinel : this.cleanCurrentList()) {
                if (sentinel.allTargets.isReverseEventTarget(sentinel, event) && sentinel.targetingHelper.canSee(entity) && !sentinel.targetingHelper.isIgnored(entity)) {
                    sentinel.targetingHelper.addTarget(entity.getUniqueId());
                }
                if (!sentinel.allAvoids.isReverseEventTarget(sentinel, event) || !sentinel.targetingHelper.canSee(entity) || sentinel.targetingHelper.isIgnored(entity)) continue;
                sentinel.targetingHelper.addAvoid(entity.getUniqueId());
            }
        }
    }

    @EventHandler
    public void whenAPlayerDies(PlayerDeathEvent event) {
        if (event.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            SentinelTrait sentinel;
            Entity damager = ((EntityDamageByEntityEvent)event.getEntity().getLastDamageCause()).getDamager();
            if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Entity) {
                damager = (Entity)((Projectile)damager).getShooter();
            }
            if (damager instanceof Player && CitizensAPI.getNPCRegistry().isNPC(damager) && (sentinel = SentinelUtilities.tryGetSentinel(damager)) != null && sentinel.getNPC().requiresNameHologram() && event.getDeathMessage() != null) {
                event.setDeathMessage(event.getDeathMessage().replace(sentinel.getNPC().getEntity().getName(), sentinel.getNPC().getFullName()));
            }
        }
    }

    @EventHandler
    public void whenAPlayerChangesWorld(PlayerChangedWorldEvent event) {
        VelocityTracker.playerVelocityEstimates.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void whenAnEnemyDies(EntityDeathEvent event) {
        UUID dead = event.getEntity().getUniqueId();
        if (event.getEntity() instanceof Player) {
            VelocityTracker.playerVelocityEstimates.remove(dead);
        }
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            sentinel.whenAnEnemyDies(dead);
            sentinel.whenSomethingDies(event);
        }
    }

    @EventHandler
    public void whenWeDie(EntityDeathEvent event) {
        SentinelTrait sentinel = SentinelUtilities.tryGetSentinel((Entity)event.getEntity());
        if (sentinel != null) {
            if (event.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent) {
                Entity damager = ((EntityDamageByEntityEvent)event.getEntity().getLastDamageCause()).getDamager();
                if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Entity) {
                    damager = (Entity)((Projectile)damager).getShooter();
                }
                if (damager instanceof Player && !CitizensAPI.getNPCRegistry().isNPC(damager)) {
                    TrackedKillToBlock blocker = killStatsToBlock.get(damager.getUniqueId());
                    if (blocker == null) {
                        blocker = new TrackedKillToBlock();
                        killStatsToBlock.put(damager.getUniqueId(), blocker);
                    }
                    blocker.addOne();
                }
            }
            sentinel.whenWeDie(event);
        }
    }

    @EventHandler
    public void onStatisticIncrement(PlayerStatisticIncrementEvent event) {
        UUID uuid;
        TrackedKillToBlock blocker;
        if (event.getStatistic() == Statistic.PLAYER_KILLS && (blocker = killStatsToBlock.get(uuid = event.getPlayer().getUniqueId())) != null) {
            --blocker.killCount;
            if (blocker.systemTick != SentinelPlugin.instance.tickTimeTotal) {
                killStatsToBlock.remove(uuid);
                return;
            }
            if (blocker.killCount <= 0) {
                killStatsToBlock.remove(uuid);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleports(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        UUID uuid = event.getPlayer().getUniqueId();
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            if (sentinel.getGuarding() == null || !sentinel.getGuarding().equals(uuid)) continue;
            sentinel.onPlayerTeleports(event);
        }
    }

    @EventHandler
    public void onPlayerMovesInRange(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getTo().toVector().toBlockVector().equals((Object)event.getFrom().toVector().toBlockVector())) {
            return;
        }
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            sentinel.onPlayerMovesInRange(event);
        }
    }

    @EventHandler
    public void onInvClose(InventoryCloseEvent event) {
        String invTitle = SentinelNMSHelper.getInventoryTitle((InventoryEvent)event);
        if (invTitle.startsWith(InvPrefix)) {
            int id = Integer.parseInt(invTitle.substring(InvPrefix.length()));
            NPC npc = CitizensAPI.getNPCRegistry().getById(id);
            if (npc != null && npc.hasTrait(SentinelTrait.class)) {
                ArrayList<ItemStack> its = ((SentinelTrait)npc.getOrAddTrait(SentinelTrait.class)).drops;
                its.clear();
                for (ItemStack it : event.getInventory().getContents()) {
                    if (it == null || it.getType() == Material.AIR) continue;
                    its.add(it);
                }
            }
        }
    }

    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent event) {
        SentinelTrait sentinel = SentinelUtilities.tryGetSentinel((Entity)event.getPlayer());
        if (sentinel != null && !sentinel.needsAmmo) {
            event.setCancelled(true);
        }
    }

    public static class TrackedKillToBlock {
        public int killCount = 0;
        public long systemTick = 0L;

        public void addOne() {
            if (this.systemTick != SentinelPlugin.instance.tickTimeTotal) {
                this.killCount = 0;
                this.systemTick = SentinelPlugin.instance.tickTimeTotal;
            }
            ++this.killCount;
        }
    }
}

