/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.metrics;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.bukkit.Bukkit;
import org.mcmonkey.sentinel.SentinelPlugin;

public class StatsRecord
extends Thread {
    public String content;

    public static void trigger() {
        StatsRecord recorder = new StatsRecord();
        recorder.gather();
        recorder.start();
    }

    public static String hash_md5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes, 0, bytes.length);
            return new BigInteger(1, md.digest()).toString(16).substring(0, 16);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void gather() {
        String platform;
        String differentiator = StatsRecord.hash_md5((Bukkit.getServer().getMotd() + Bukkit.getServer().getPort()).getBytes(StandardCharsets.UTF_8));
        String mcVersion = Bukkit.getVersion();
        int firstDash = mcVersion.indexOf(45);
        int secondDash = firstDash == -1 ? -1 : mcVersion.indexOf(45, firstDash + 1);
        int mcPart = mcVersion.indexOf("(MC: ");
        int endPart = mcPart == -1 ? -1 : mcVersion.indexOf(")", mcPart);
        String string = platform = secondDash == -1 ? "" : mcVersion.substring(firstDash + 1, secondDash);
        if (platform.matches("^\\d+$")) {
            platform = Bukkit.getName();
        }
        mcVersion = endPart == -1 ? "" : mcVersion.substring(mcPart + "(MC: ".length(), endPart);
        this.content = "postid=pluginstats&plugin=Sentinel&differentiator=" + differentiator + "&pl_plugin_version=" + URLEncoder.encode(SentinelPlugin.instance.getDescription().getVersion()) + "&pl_platform=" + URLEncoder.encode(platform) + "&pl_minecraft_version=" + URLEncoder.encode(mcVersion) + "&pl_player_count=" + Bukkit.getOnlinePlayers().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader in = null;
        try {
            URL url = new URL("https://stats.mcmonkey.org/Stats/Submit");
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setConnectTimeout(10000);
            uc.connect();
            uc.getOutputStream().write(this.content.getBytes(StandardCharsets.UTF_8));
            in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            String Result = in.readLine();
            in.close();
        }
        catch (Exception e) {
            if (SentinelPlugin.debugMe) {
                System.out.println("Sentinel stat issue: " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        finally {
            block14: {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    if (!SentinelPlugin.debugMe) break block14;
                    System.out.println("Sentinel stat issue (backup): " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
        }
    }
}

