/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.util.AbstractMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelHelperObject;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.targeting.SentinelTarget;
import org.mcmonkey.sentinel.utilities.SentinelAPIBreakageFix;
import org.mcmonkey.sentinel.utilities.SentinelVersionCompat;

public class SentinelWeaponHelper
extends SentinelHelperObject {
    public static final EntityType LINGERING_POTION;
    public static final EntityType TIPPED_ARROW;
    public static final EntityType SPLASH_POTION;

    public void firePotion(ItemStack potion, Location target, Vector lead) {
        if (SentinelVersionCompat.v1_9 && potion.getType() == Material.POTION) {
            potion = potion.clone();
            potion.setType(Material.SPLASH_POTION);
        }
        ++this.sentinel.stats_potionsThrown;
        AbstractMap.SimpleEntry<Location, Vector> start = this.sentinel.getLaunchDetail(target, lead);
        Entity entpotion = SentinelVersionCompat.v1_14 || !SentinelVersionCompat.v1_9 ? start.getKey().getWorld().spawnEntity(start.getKey(), SPLASH_POTION) : start.getKey().getWorld().spawnEntity(start.getKey(), potion.getType() == Material.SPLASH_POTION ? SPLASH_POTION : LINGERING_POTION);
        ((ThrownPotion)entpotion).setShooter((ProjectileSource)this.getLivingEntity());
        ((ThrownPotion)entpotion).setItem(potion);
        entpotion.setVelocity(this.sentinel.fixForAcc(start.getValue()));
        this.sentinel.swingWeapon();
    }

    public void fireArrow(ItemStack type, Location target, Vector lead) {
        Entity arrow;
        Vector baseVelocity;
        Location launchStart;
        if (SentinelVersionCompat.v1_14 && type.getType() == Material.FIREWORK_ROCKET) {
            launchStart = this.sentinel.getLivingEntity().getEyeLocation();
            launchStart = launchStart.clone().add(launchStart.getDirection());
            baseVelocity = target.toVector().subtract(launchStart.toVector().add(lead));
            if (baseVelocity.lengthSquared() > 0.0) {
                baseVelocity = baseVelocity.normalize();
            }
            baseVelocity = baseVelocity.multiply(2);
        } else {
            AbstractMap.SimpleEntry<Location, Vector> start = this.sentinel.getLaunchDetail(target, lead);
            if (start == null || start.getKey() == null) {
                return;
            }
            launchStart = start.getKey();
            baseVelocity = start.getValue();
        }
        Vector velocity = this.sentinel.fixForAcc(baseVelocity);
        ++this.sentinel.stats_arrowsFired;
        if (SentinelVersionCompat.v1_9) {
            if (SentinelVersionCompat.v1_14) {
                double length = Math.max(1.0, velocity.length());
                if (type.getType() == Material.FIREWORK_ROCKET) {
                    FireworkMeta meta = (FireworkMeta)type.getItemMeta();
                    meta.setPower(3);
                    arrow = launchStart.getWorld().spawn(launchStart, SentinelAPIBreakageFix.ENTITY_TYPE_FIREWORK.getEntityClass(), e -> {
                        ((Firework)e).setShotAtAngle(true);
                        ((Firework)e).setFireworkMeta(meta);
                        e.setVelocity(velocity);
                    });
                } else {
                    Class toShoot = type.getType() == Material.SPECTRAL_ARROW ? SpectralArrow.class : (type.getType() == Material.TIPPED_ARROW ? TippedArrow.class : Arrow.class);
                    arrow = launchStart.getWorld().spawnArrow(launchStart, velocity.multiply(1.0 / length), (float)length, 0.0f, toShoot);
                    ((Projectile)arrow).setShooter((ProjectileSource)this.getLivingEntity());
                    ((AbstractArrow)arrow).setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
                    if (type.getItemMeta() instanceof PotionMeta) {
                        PotionData data = ((PotionMeta)type.getItemMeta()).getBasePotionData();
                        if (data.getType() == null || data.getType() == SentinelAPIBreakageFix.POTION_TYPE_UNCRAFTABLE) {
                            if (SentinelPlugin.debugMe) {
                                this.sentinel.debug("Potion data '" + data + "' for '" + type + "' is invalid.");
                            }
                        } else {
                            ((Arrow)arrow).setBasePotionData(data);
                            for (PotionEffect effect : ((PotionMeta)type.getItemMeta()).getCustomEffects()) {
                                ((Arrow)arrow).addCustomEffect(effect, true);
                            }
                        }
                    }
                }
            } else {
                arrow = launchStart.getWorld().spawnEntity(launchStart, type.getType() == Material.SPECTRAL_ARROW ? EntityType.SPECTRAL_ARROW : (type.getType() == Material.TIPPED_ARROW ? TIPPED_ARROW : EntityType.ARROW));
                arrow.setVelocity(velocity);
                ((Projectile)arrow).setShooter((ProjectileSource)this.getLivingEntity());
            }
        } else {
            arrow = launchStart.getWorld().spawnEntity(launchStart, EntityType.ARROW);
            ((Projectile)arrow).setShooter((ProjectileSource)this.getLivingEntity());
            arrow.setVelocity(velocity);
        }
        if (this.sentinel.itemHelper.getHeldItem().containsEnchantment(SentinelAPIBreakageFix.ENCHANTMENT_ARROW_FIRE)) {
            arrow.setFireTicks(10000);
        }
        if (SentinelPlugin.instance.arrowCleanupTime > 0) {
            final Entity projectile = arrow;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, new Runnable(){

                @Override
                public void run() {
                    if (projectile.isValid()) {
                        projectile.remove();
                    }
                }
            }, (long)(SentinelPlugin.instance.arrowCleanupTime + 200));
        }
        this.sentinel.useItem();
    }

    public void fireSnowball(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_snowballsThrown;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.SNOWBALL);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(2.0)));
    }

    public void fireTrident(Location target) {
        if (!SentinelVersionCompat.v1_13) {
            return;
        }
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_arrowsFired;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange() + 2.0));
        Trident ent = (Trident)spawnAt.getWorld().spawnEntity(spawnAt, EntityType.TRIDENT);
        ent.setShooter((ProjectileSource)this.getLivingEntity());
        ItemStack it = this.itemHelper.getHeldItem();
        if (it != null && it.getType() == Material.TRIDENT) {
            ent.setItem(it);
        }
        if (SentinelVersionCompat.v1_14) {
            ent.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        }
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(2.0)));
    }

    public void fireEgg(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_eggsThrown;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.EGG);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(2.0)));
    }

    public void firePearl(LivingEntity target) {
        this.sentinel.swingWeapon();
        this.sentinel.faceLocation(target.getEyeLocation());
        ++this.sentinel.stats_pearlsUsed;
        target.setVelocity(target.getVelocity().add(new Vector(0.0, this.sentinel.getDamage(true), 0.0)));
    }

    public void fireFireball(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_fireballsFired;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.SMALL_FIREBALL);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(4)));
    }

    public void fireSkull(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_skullsThrown;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.WITHER_SKULL);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(4)));
    }

    public void fireLlamaSpit(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_llamaSpitShot;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.LLAMA_SPIT);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(4)));
    }

    public void fireShulkerBullet(LivingEntity entity) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_shulkerBulletsShot;
        this.sentinel.faceLocation(entity.getEyeLocation());
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.SHULKER_BULLET);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(entity.getEyeLocation().clone().subtract(spawnAt).toVector().normalize()));
        ((ShulkerBullet)ent).setTarget((Entity)entity);
    }

    public void fireEvokerFangs(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_evokerFangsSpawned;
        this.sentinel.faceLocation(target);
        if (SentinelVersionCompat.v1_13) {
            this.getLivingEntity().getWorld().spawnParticle((Particle)SentinelAPIBreakageFix.PARTICLE_SPELL, this.getLivingEntity().getEyeLocation().add(0.0, 1.0, 0.0), 10, 1.0, 1.0, 1.0);
        }
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection().setY(0).normalize();
        Location start = this.getLivingEntity().getLocation().clone().add(forward.clone().multiply(Math.max(3.0, this.sentinel.firingMinimumRange())));
        int count = (int)this.getLivingEntity().getLocation().distance(target) + 2;
        for (int i = 0; i < count; ++i) {
            int index = i;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, () -> {
                if (!this.getNPC().isSpawned()) {
                    return;
                }
                Location loc = start.clone().add(forward.clone().multiply(index));
                start.getWorld().spawnEntity(loc, EntityType.EVOKER_FANGS);
            }, (long)(i * 3 + 5));
        }
    }

    public void punch(LivingEntity entity) {
        if (!this.getNPC().isSpawned()) {
            return;
        }
        this.sentinel.faceLocation(entity.getEyeLocation());
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_punches;
        if (SentinelPlugin.instance.workaroundDamage) {
            double damage = this.sentinel.getDamage(false);
            if (SentinelPlugin.debugMe) {
                this.debug("workaround damage value at " + damage + " yields " + damage * (1.0 - this.sentinel.getArmor(entity)));
            }
            if (!this.sentinel.enemyDrops) {
                this.sentinel.needsDropsClear.add(entity.getUniqueId());
            }
            entity.damage(damage * (1.0 - this.sentinel.getArmor(entity)));
            this.knockback(entity, 1.0f);
            this.addedPunchEffects(entity);
        } else {
            if (this.sentinel.damage < 0.0 && SentinelVersionCompat.v1_15 && SentinelPlugin.instance.doNativeAttack) {
                if (SentinelTarget.NATIVE_COMBAT_CAPABLE_TYPES.contains(this.getLivingEntity().getType())) {
                    this.debug("Punch/native/living-entity");
                    this.getLivingEntity().attack((Entity)entity);
                    return;
                }
                if (this.getLivingEntity() instanceof Player && SentinelVersionCompat.v1_17) {
                    this.debug("Punch/native/player");
                    ItemStack hand = this.getLivingEntity().getEquipment().getItemInMainHand().clone();
                    this.getLivingEntity().attack((Entity)entity);
                    this.getLivingEntity().getEquipment().setItemInMainHand(hand);
                    return;
                }
            }
            double damage = this.sentinel.getDamage(false);
            if (SentinelPlugin.debugMe) {
                this.debug("Punch/natural for " + damage);
            }
            entity.damage(damage, (Entity)this.getLivingEntity());
            this.addedPunchEffects(entity);
        }
    }

    public void addedPunchEffects(LivingEntity entity) {
        if (entity == null || entity.isDead()) {
            return;
        }
        if (!this.getNPC().isSpawned()) {
            return;
        }
        ItemStack item = SentinelUtilities.getHeldItem(this.getLivingEntity());
        if (item == null || item.getType() == Material.AIR || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasEnchants()) {
            return;
        }
        if (meta.hasEnchant(Enchantment.FIRE_ASPECT)) {
            int ticks = meta.getEnchantLevel(Enchantment.FIRE_ASPECT) * 80;
            int prot = SentinelUtilities.getFireProtection(entity);
            if (prot > 0) {
                ticks = (int)((double)ticks - Math.floor((float)ticks * (float)prot * 0.15f));
            }
            if (ticks > 0) {
                entity.setFireTicks(ticks);
            }
        }
        if (meta.hasEnchant(Enchantment.KNOCKBACK)) {
            this.knockback(entity, 1.0f + (float)meta.getEnchantLevel(Enchantment.KNOCKBACK) * 0.5f);
        }
    }

    public void knockback(LivingEntity entity, float force) {
        Vector direction;
        float resist;
        if (entity == null || entity.isDead() || !this.getNPC().isSpawned()) {
            return;
        }
        if (SentinelVersionCompat.v1_12 && (double)(resist = (float)entity.getAttribute((Attribute)SentinelAPIBreakageFix.ATTRIBUTE_GENERIC_KNOCKBACK_RESISTANCE).getValue()) > 0.0 && (double)resist <= 1.0) {
            force = (float)((double)force * (1.0 - (double)resist));
        }
        if ((direction = entity.getLocation().toVector().subtract(this.getLivingEntity().getLocation().toVector())).lengthSquared() > 0.0) {
            direction = direction.normalize();
        }
        Vector relative = direction.clone().setY(0.75);
        relative.multiply(0.5 / Math.max(1.0, entity.getVelocity().length()));
        relative.setX(relative.getX() * (double)force);
        relative.setZ(relative.getZ() * (double)force);
        entity.setVelocity(entity.getVelocity().multiply(0.25).add(relative));
        if (SentinelPlugin.debugMe) {
            this.debug("applied knockback velocity adder of " + relative);
        }
    }

    static {
        if (SentinelVersionCompat.v1_21) {
            LINGERING_POTION = EntityType.LINGERING_POTION;
            SPLASH_POTION = EntityType.SPLASH_POTION;
            TIPPED_ARROW = EntityType.ARROW;
        } else if (SentinelVersionCompat.v1_14) {
            LINGERING_POTION = EntityType.valueOf((String)"SPLASH_POTION");
            SPLASH_POTION = EntityType.valueOf((String)"SPLASH_POTION");
            TIPPED_ARROW = EntityType.ARROW;
        } else if (SentinelVersionCompat.v1_9) {
            LINGERING_POTION = EntityType.valueOf((String)"LINGERING_POTION");
            SPLASH_POTION = EntityType.valueOf((String)"SPLASH_POTION");
            TIPPED_ARROW = EntityType.valueOf((String)"TIPPED_ARROW");
        } else {
            LINGERING_POTION = null;
            SPLASH_POTION = null;
            TIPPED_ARROW = null;
        }
    }
}

