/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import javax.script.CompiledScript;
import javax.script.ScriptException;
import net.citizensnpcs.api.scripting.ContextProvider;
import net.citizensnpcs.api.scripting.Script;
import net.citizensnpcs.api.scripting.ScriptFactory;
import net.citizensnpcs.api.scripting.SimpleScript;

public class SimpleScriptFactory
implements ScriptFactory {
    private final CompiledScript src;
    private final ContextProvider[] providers;

    SimpleScriptFactory(CompiledScript src, ContextProvider ... providers) {
        if (src == null) {
            throw new IllegalArgumentException("src cannot be null");
        }
        if (providers == null) {
            providers = new ContextProvider[]{};
        }
        this.src = src;
        this.providers = providers;
    }

    @Override
    public Script newInstance() {
        SimpleScript script;
        try {
            script = new SimpleScript(this.src);
        }
        catch (ScriptException e) {
            return null;
        }
        for (ContextProvider provider : this.providers) {
            provider.provide(script);
        }
        return script;
    }
}

