/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait;

import net.citizensnpcs.api.scripting.ContextProvider;
import net.citizensnpcs.api.scripting.Script;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class EventRegistrar
implements ContextProvider {
    private final Plugin plugin;

    public EventRegistrar(Plugin plugin) {
        if (plugin == null || !plugin.isEnabled()) {
            throw new IllegalArgumentException("invalid plugin supplied");
        }
        this.plugin = plugin;
    }

    @Override
    public void provide(Script script) {
        script.setAttribute("events", new Events(this.plugin, script));
    }

    public static class Events {
        private final Plugin plugin;
        private final Script script;

        public Events(Plugin plugin, Script script) {
            this.plugin = plugin;
            this.script = script;
        }

        public void register(String functionName, Class<? extends Event> eventClass) {
            this.registerEvent(null, functionName, eventClass);
        }

        private void registerEvent(final Object object, final String functionName, final Class<? extends Event> eventClass) {
            if (!this.plugin.isEnabled()) {
                throw new IllegalStateException("plugin is no longer validw");
            }
            PluginManager manager = this.plugin.getServer().getPluginManager();
            manager.registerEvent(eventClass, new Listener(){}, EventPriority.NORMAL, new EventExecutor(){

                public void execute(Listener listener, Event event) throws EventException {
                    try {
                        if (!eventClass.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        if (object != null) {
                            Events.this.script.invoke(object, functionName, event);
                        } else {
                            Events.this.script.invoke(functionName, event);
                        }
                    }
                    catch (Throwable t) {
                        throw new EventException(t);
                    }
                }
            }, this.plugin);
        }

        public void register(Object instance, String functionName, Class<? extends Event> eventClass) {
            this.registerEvent(instance, functionName, eventClass);
        }
    }
}

