/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command.command;

import java.io.File;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.scripting.CompileCallback;
import net.citizensnpcs.api.scripting.ScriptFactory;
import net.citizensnpcs.command.Command;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.Requirements;
import net.citizensnpcs.command.ServerCommand;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Requirements
public class AdminCommands {
    private final Citizens plugin;

    public AdminCommands(Citizens plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"citizens"}, modifiers={"script"}, desc="compile and run a script", min=2, max=2, permission="scripts.run")
    @ServerCommand
    public void runScript(CommandContext args, final CommandSender sender, NPC npc) throws CommandException {
        File file = new File(args.getString(1));
        if (!file.exists()) {
            throw new CommandException("file doesn't exist!");
        }
        sender.sendMessage("Could put into queue? " + CitizensAPI.getScriptCompiler().compile(file).withCallback(new CompileCallback(){

            @Override
            public void onScriptCompiled(ScriptFactory script) {
                script.newInstance();
                sender.sendMessage("Script compiled.");
            }
        }).begin());
    }

    @Command(aliases={"citizens"}, desc="Show basic plugin information", max=0, permission="admin")
    public void citizens(CommandContext args, Player player, NPC npc) {
        Messaging.send((CommandSender)player, "          " + StringHelper.wrapHeader("<e>Citizens v" + this.plugin.getDescription().getVersion()));
        Messaging.send((CommandSender)player, "     <7>-- <c>Written by fullwall and aPunch");
        Messaging.send((CommandSender)player, "     <7>-- <c>Source: http://github.com/CitizensDev");
        Messaging.send((CommandSender)player, "     <7>-- <c>Website: " + this.plugin.getDescription().getWebsite());
    }

    @Command(aliases={"citizens"}, usage="reload", desc="Reload Citizens", modifiers={"reload"}, min=1, max=1, permission="admin")
    @ServerCommand
    public void reload(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Messaging.send(sender, "<e>Reloading Citizens...");
        try {
            this.plugin.reload();
            Messaging.send(sender, "<e>Citizens reloaded.");
        }
        catch (NPCLoadException ex) {
            ex.printStackTrace();
            throw new CommandException("Error occured while reloading, see console.");
        }
    }

    @Command(aliases={"citizens"}, usage="save", desc="Save NPCs", modifiers={"save"}, min=1, max=1, permission="admin")
    @ServerCommand
    public void save(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.send(sender, "<e>Saving Citizens...");
        this.plugin.save();
        Messaging.send(sender, "<e>Citizens saved.");
    }
}

