/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text.prompt;

import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.text.prompt.TextAddPrompt;
import net.citizensnpcs.trait.text.prompt.TextEditStartPrompt;
import net.citizensnpcs.trait.text.prompt.TextRemovePrompt;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class StartPrompt
extends StringPrompt {
    private final Text text;

    public StartPrompt(Text text) {
        this.text = text;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        if (input.equalsIgnoreCase("add")) {
            return new TextAddPrompt(this.text);
        }
        if (input.equalsIgnoreCase("edit")) {
            return new TextEditStartPrompt(this.text);
        }
        if (input.equalsIgnoreCase("remove")) {
            return new TextRemovePrompt(this.text);
        }
        if (input.equalsIgnoreCase("random")) {
            Messaging.send((CommandSender)((Player)context.getForWhom()), "<e>Random talker <a>set to <e>" + this.text.toggleRandomTalker() + "<a>.");
        } else if (input.equalsIgnoreCase("close")) {
            Messaging.send((CommandSender)((Player)context.getForWhom()), "<e>Close talker <a>set to <e>" + this.text.toggle() + "<a>.");
        } else {
            Messaging.sendError((CommandSender)((Player)context.getForWhom()), "Invalid edit type.");
        }
        return new StartPrompt(this.text);
    }

    public String getPromptText(ConversationContext context) {
        return StringHelper.parseColors("<a>Type <e>add <a>to add an entry, <e>edit <a>to edit entries, <e>remove <a>to remove entries, <e>close <a>to toggle the NPC as a close talker, and <e>random <a>to toggle the NPC as a random talker.");
    }
}

