/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Metrics {
    private final YamlConfiguration configuration;
    private final Map<Plugin, Set<Plotter>> customData = Collections.synchronizedMap(new HashMap());
    private final String guid;
    private static final String BASE_URL = "http://metrics.griefcraft.com";
    private static final String CONFIG_FILE = "plugins/PluginMetrics/config.yml";
    private static final int PING_INTERVAL = 10;
    private static final String REPORT_URL = "/report/%s";
    private static final int REVISION = 4;

    public Metrics() throws IOException {
        File file = new File(CONFIG_FILE);
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        this.configuration.addDefault("opt-out", (Object)false);
        this.configuration.addDefault("guid", (Object)UUID.randomUUID().toString());
        if (this.configuration.get("guid", null) == null) {
            this.configuration.options().header(BASE_URL).copyDefaults(true);
            this.configuration.save(file);
        }
        this.guid = this.configuration.getString("guid");
    }

    public void addCustomData(Plugin plugin, Plotter plotter) {
        Set<Plotter> plotters = this.customData.get(plugin);
        if (plotters == null) {
            plotters = Collections.synchronizedSet(new LinkedHashSet());
            this.customData.put(plugin, plotters);
        }
        plotters.add(plotter);
    }

    public void beginMeasuringPlugin(final Plugin plugin) throws IOException {
        if (this.configuration.getBoolean("opt-out", false)) {
            return;
        }
        this.postPlugin(plugin, false);
        plugin.getServer().getScheduler().scheduleAsyncRepeatingTask(plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    Metrics.this.postPlugin(plugin, true);
                }
                catch (IOException e) {
                    System.out.println("[Metrics] " + e.getMessage());
                }
            }
        }, 12000L, 12000L);
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void postPlugin(Plugin plugin, boolean isPing) throws IOException {
        Set<Plotter> plotters;
        String response = "ERR No response";
        String data = Metrics.encode("guid") + '=' + Metrics.encode(this.guid) + '&' + Metrics.encode("version") + '=' + Metrics.encode(plugin.getDescription().getVersion()) + '&' + Metrics.encode("server") + '=' + Metrics.encode(Bukkit.getVersion()) + '&' + Metrics.encode("players") + '=' + Metrics.encode(String.valueOf(Bukkit.getServer().getOnlinePlayers().length)) + '&' + Metrics.encode("revision") + '=' + Metrics.encode("4");
        if (isPing) {
            data = data + '&' + Metrics.encode("ping") + '=' + Metrics.encode("true");
        }
        if ((plotters = this.customData.get(plugin)) != null) {
            for (Plotter plotter : plotters) {
                data = data + "&" + Metrics.encode("Custom" + plotter.getColumnName()) + "=" + Metrics.encode(Integer.toString(plotter.getValue()));
            }
        }
        URL url = new URL(BASE_URL + String.format(REPORT_URL, plugin.getDescription().getName()));
        URLConnection connection = this.isMineshafterPresent() ? url.openConnection(Proxy.NO_PROXY) : url.openConnection();
        connection.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(data);
        writer.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        response = reader.readLine();
        writer.close();
        reader.close();
        if (response.startsWith("ERR")) {
            throw new IOException(response);
        }
        if (response.contains("OK This is your first update this hour") && plotters != null) {
            for (Plotter plotter : plotters) {
                plotter.reset();
            }
        }
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }

    public static abstract class Plotter {
        public boolean equals(Object object) {
            if (!(object instanceof Plotter)) {
                return false;
            }
            Plotter plotter = (Plotter)object;
            return plotter.getColumnName().equals(this.getColumnName()) && plotter.getValue() == this.getValue();
        }

        public abstract String getColumnName();

        public abstract int getValue();

        public int hashCode() {
            return this.getColumnName().hashCode() + this.getValue();
        }

        public void reset() {
        }
    }
}

