/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.QueryRunner;
import net.citizensnpcs.api.util.ResultSetHandler;
import net.citizensnpcs.api.util.Storage;

public class DatabaseStorage
implements Storage {
    private Connection conn;
    private final QueryRunner queryRunner = new QueryRunner();
    private final Map<String, Table> tables = Maps.newHashMap();
    private final Map<String, Traversed> traverseCache = Maps.newHashMap();
    private final String url;
    private final String username;
    private final String password;
    private static final Pattern INTEGER = Pattern.compile("([\\+-]?\\d+)([eE][\\+-]?\\d+)?");
    private static final Traversed INVALID_TRAVERSAL = new Traversed(null, null, null);

    public DatabaseStorage(String driver, String url, String username, String password) throws SQLException {
        this.url = url = "jdbc:" + url;
        this.username = username;
        this.password = password;
        DatabaseType.match(driver).load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForeignKey(Table from, Table to) {
        String fk = "fk_" + to.name;
        if (from.foreignKeys.containsKey(fk)) {
            return;
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("ALTER TABLE `" + from.name + "` ADD " + fk + " " + to.primaryKeyType);
            stmt.execute();
            DatabaseStorage.closeQuietly(stmt);
            stmt = conn.prepareStatement("ALTER TABLE `" + from.name + "` ADD FOREIGN KEY (`" + fk + "`) REFERENCES `" + to.name + "` (`" + to.name + "_id" + "`)");
            stmt.execute();
            from.addForeignKey(fk, new ForeignKey(fk));
            DatabaseStorage.closeQuietly(stmt);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DatabaseStorage.closeQuietly(stmt);
        }
    }

    private Table createTable(String name, int type, boolean autoIncrement) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        Table t = this.tables.get(name);
        if (t != null) {
            return t;
        }
        String pk = name + "_id";
        String pkType = "";
        switch (type) {
            case 4: {
                pkType = "INTEGER NOT NULL";
                if (!autoIncrement) break;
                pkType = pkType + " AUTOINCREMENT";
                break;
            }
            case 12: {
                pkType = "varchar(255) NOT NULL";
                break;
            }
            default: {
                throw new IllegalArgumentException("type not supported");
            }
        }
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        Table created = null;
        try {
            stmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS " + name + "(`" + pk + "` " + pkType + ", PRIMARY KEY (`" + pk + "`))");
            stmt.execute();
            created = new Table().setName(name).setPrimaryKey(pk).setPrimaryKeyType(pkType);
            this.tables.put(name, created);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return created;
    }

    private String ensureRelation(String pk, Table from, final Table to) {
        Connection conn = this.getConnection();
        try {
            String existing = this.queryRunner.query(conn, "SELECT `fk_" + to.name + "` FROM " + from.name + " WHERE " + from.primaryKey + " = ?", new ResultSetHandler<String>(){

                @Override
                public String handle(ResultSet rs) throws SQLException {
                    return rs.getString("fk_" + to.name);
                }
            }, pk);
            if (existing == null) {
                String generated = to.generateRow();
                this.queryRunner.update(conn, "UPDATE `" + from.name + "` SET `fk_" + to.name + "=?", (Object)generated);
                return generated;
            }
            return existing;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Connection getConnection() {
        block6: {
            if (this.conn != null) {
                try {
                    this.conn.prepareStatement("SELECT 1;").execute();
                }
                catch (SQLException ex) {
                    if (!"08S01".equals(ex.getSQLState())) break block6;
                    DatabaseStorage.closeQuietly(this.conn);
                }
            }
        }
        try {
            if (this.conn == null || this.conn.isClosed()) {
                this.conn = this.username.isEmpty() && this.password.isEmpty() ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.username, this.password);
                return this.conn;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
        return this.conn;
    }

    @Override
    public DataKey getKey(String root) {
        return new DatabaseKey(root);
    }

    @Override
    public void load() {
        this.tables.clear();
        this.traverseCache.clear();
        Connection conn = this.getConnection();
        try {
            ResultSet rs = conn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                this.tables.put(rs.getString("TABLE_NAME"), new Table());
            }
            rs.close();
            for (Map.Entry<String, Table> entry : this.tables.entrySet()) {
                Table table = entry.getValue();
                table.name = entry.getKey();
                rs = conn.getMetaData().getColumns(null, null, entry.getKey(), null);
                while (rs.next()) {
                    table.columns.add(rs.getString("COLUMN_NAME"));
                }
                rs.close();
                rs = conn.getMetaData().getPrimaryKeys(null, null, entry.getKey());
                while (rs.next()) {
                    table.primaryKey = rs.getString("COLUMN_NAME");
                    table.setPrimaryKeyType(rs.getMetaData().getColumnTypeName(4));
                }
                rs.close();
                rs = conn.getMetaData().getImportedKeys(null, null, entry.getKey());
                while (rs.next()) {
                    assert (rs.getString("PKCOLUMN_NAME") != null);
                    ForeignKey key = new ForeignKey(rs.getString("PKCOLUMN_NAME"));
                    table.foreignKeys.put(key.localColumn, key);
                }
                rs.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void save() {
        DatabaseStorage.commitAndCloseQuietly(this.conn);
    }

    public String toString() {
        return "DatabaseStorage {url=" + this.url + ", username=" + this.username + ", password=" + this.password + "}";
    }

    private static void closeQuietly(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeQuietly(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeQuietly(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commitAndCloseQuietly(Connection conn) {
        try {
            try {
                conn.commit();
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static boolean loadDriver(ClassLoader classLoader, String driverClassName) {
        try {
            classLoader.loadClass(driverClassName).newInstance();
            return true;
        }
        catch (IllegalAccessException e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class Traversed {
        private final String column;
        private final Table found;
        private final String key;

        Traversed(Table found, String pk, String column) {
            this.found = found;
            this.key = pk;
            this.column = column;
        }
    }

    private class Table {
        final List<String> columns = Lists.newArrayList();
        final Map<String, ForeignKey> foreignKeys = Maps.newHashMap();
        String name;
        String primaryKey;
        String primaryKeyType;

        private Table() {
        }

        public void addForeignKey(String fk, ForeignKey foreignKey) {
            this.foreignKeys.put(fk, foreignKey);
            this.columns.add(fk);
        }

        public String generateRow() {
            String vals = Joiner.on((String)", ").join(this.columns);
            StringBuilder nullBuilder = new StringBuilder();
            for (int i = 0; i < this.columns.size(); ++i) {
                nullBuilder.append("NULL,");
            }
            String nulls = nullBuilder.substring(0, nullBuilder.length() - 2).toString();
            Connection conn = DatabaseStorage.this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement("INSERT INTO `" + this.name + "` (" + vals + ") VALUES (" + nulls + ")", 1);
                stmt.executeQuery();
                rs = stmt.getGeneratedKeys();
                if (!rs.next()) {
                    return null;
                }
                return rs.getString(this.primaryKey);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public void insert(String primary) {
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                DatabaseStorage.this.queryRunner.update(conn, "INSERT INTO `" + this.name + "` (`" + this.primaryKey + "`) VALUES (?)", (Object)primary);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }

        public Table setName(String tableName) {
            this.name = tableName;
            return this;
        }

        public Table setPrimaryKey(String pk) {
            this.primaryKey = pk;
            return this;
        }

        public Table setPrimaryKeyType(String type) {
            this.primaryKeyType = type;
            return this;
        }

        public String toString() {
            return "Table {name=" + this.name + ", primaryKey=" + this.primaryKey + ", foreignKeys=" + this.foreignKeys + ", columns=" + this.columns + "}";
        }
    }

    private static class ForeignKey {
        final String localColumn;

        ForeignKey(String from) {
            this.localColumn = from;
        }
    }

    public static enum DatabaseType {
        H2("org.h2.Driver"),
        MYSQL("com.mysql.jdbc.Driver"),
        POSTGRE("org.postgresql.Driver"),
        SQLITE("org.sqlite.JDBC");

        private final String driver;
        private boolean loaded = false;

        private DatabaseType(String driver) {
            this.driver = driver;
        }

        public boolean load() {
            if (this.loaded) {
                return true;
            }
            if (DatabaseStorage.loadDriver(DatabaseStorage.class.getClassLoader(), this.driver)) {
                this.loaded = true;
            }
            return this.loaded;
        }

        public static DatabaseType match(String driver) {
            for (DatabaseType type : DatabaseType.values()) {
                if (!type.name().toLowerCase().contains(driver)) continue;
                return type;
            }
            return null;
        }
    }

    public class DatabaseKey
    extends DataKey {
        private final String current;

        private DatabaseKey(String root) {
            this.current = root;
        }

        private DatabaseKey() {
            this("");
        }

        private String createRelativeKey(String from) {
            if (from.isEmpty()) {
                return this.current;
            }
            if (from.charAt(0) == '.') {
                return this.current.isEmpty() ? from.substring(1, from.length()) : this.current + from;
            }
            return this.current.isEmpty() ? from : this.current + "." + from;
        }

        @Override
        public boolean getBoolean(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return false;
            }
            Boolean value = this.getValue(t, new ResultSetHandler<Boolean>(){

                @Override
                public Boolean handle(ResultSet rs) throws SQLException {
                    return rs.getBoolean(t.column);
                }
            });
            return value == null ? false : value;
        }

        @Override
        public double getDouble(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return 0.0;
            }
            Double value = this.getValue(t, new ResultSetHandler<Double>(){

                @Override
                public Double handle(ResultSet rs) throws SQLException {
                    return rs.getDouble(t.column);
                }
            });
            return value == null ? 0.0 : value;
        }

        @Override
        public int getInt(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return 0;
            }
            Integer value = this.getValue(t, new ResultSetHandler<Integer>(){

                @Override
                public Integer handle(ResultSet rs) throws SQLException {
                    return rs.getInt(t.column);
                }
            });
            return value == null ? 0 : value;
        }

        @Override
        public long getLong(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return 0L;
            }
            Long value = this.getValue(t, new ResultSetHandler<Long>(){

                @Override
                public Long handle(ResultSet rs) throws SQLException {
                    return rs.getLong(t.column);
                }
            });
            return value == null ? 0L : value;
        }

        @Override
        public Object getRaw(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return null;
            }
            Object value = this.getValue(t, new ResultSetHandler<Object>(){

                @Override
                public Object handle(ResultSet rs) throws SQLException {
                    return rs.getObject(t.column);
                }
            });
            return value;
        }

        @Override
        public DataKey getRelative(String relative) {
            if (relative == null || relative.isEmpty()) {
                return this;
            }
            return new DatabaseKey(this.createRelativeKey(relative));
        }

        protected Traversed getRoot() {
            return null;
        }

        @Override
        public String getString(String key) {
            final Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return "";
            }
            String value = this.getValue(t, new ResultSetHandler<String>(){

                @Override
                public String handle(ResultSet rs) throws SQLException {
                    return rs.getString(t.column);
                }
            });
            return value == null ? "" : value;
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            ArrayList keys = Lists.newArrayList();
            if (this.current.split("\\.").length == 1) {
                return this.getSingleKeys(keys);
            }
            return keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterable<DataKey> getSingleKeys(List<DataKey> keys) {
            block8: {
                if (!DatabaseStorage.this.tables.containsKey(this.current)) {
                    return keys;
                }
                Table table = (Table)DatabaseStorage.this.tables.get(this.current);
                if (table.primaryKey == null) {
                    return keys;
                }
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    Connection conn = DatabaseStorage.this.getConnection();
                    stmt = conn.prepareStatement("SELECT `" + table.primaryKey + "` FROM `" + this.current + "`");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        final Traversed found = new Traversed(table, rs.getString(table.primaryKey), table.primaryKey);
                        keys.add(new DatabaseKey(){

                            @Override
                            public Traversed getRoot() {
                                return found;
                            }
                        });
                    }
                    DatabaseStorage.closeQuietly(stmt);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    break block8;
                }
                finally {
                    DatabaseStorage.closeQuietly(stmt);
                    DatabaseStorage.closeQuietly(rs);
                }
                DatabaseStorage.closeQuietly(rs);
            }
            return keys;
        }

        private <T> T getValue(Traversed t, ResultSetHandler<T> resultSetHandler) {
            try {
                return DatabaseStorage.this.queryRunner.query(DatabaseStorage.this.getConnection(), "SELECT `" + t.column + "` FROM " + ((Traversed)t).found.name + " WHERE `" + ((Traversed)t).found.primaryKey + "`=?", resultSetHandler, t.key);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean keyExists(String key) {
            return this.traverse(this.createRelativeKey(key), false) != INVALID_TRAVERSAL;
        }

        @Override
        public String name() {
            Traversed t = this.traverse(this.current, true);
            return t.key != null ? t.key : ((Traversed)t).found.name;
        }

        @Override
        public void removeKey(String key) {
            Traversed t = this.traverse(this.createRelativeKey(key), false);
            if (t == INVALID_TRAVERSAL) {
                return;
            }
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                if (((Traversed)t).found.columns.contains(t.column)) {
                    DatabaseStorage.this.queryRunner.update(conn, "UPDATE `" + ((Traversed)t).found.name + "` SET `" + t.column + "`=? WHERE `" + ((Traversed)t).found.primaryKey + "`=?", null, t.key);
                } else {
                    DatabaseStorage.this.queryRunner.update(conn, "DELETE FROM `" + ((Traversed)t).found.name + "` WHERE `" + ((Traversed)t).found.primaryKey + "=?", (Object)t.key);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void setBoolean(String key, boolean value) {
            this.setValue("SMALLINT", key, value);
        }

        @Override
        public void setDouble(String key, double value) {
            this.setValue("DOUBLE", key, value);
        }

        @Override
        public void setInt(String key, int value) {
            this.setValue("STRING", key, value);
        }

        @Override
        public void setLong(String key, long value) {
            this.setValue("BIGINT", key, value);
        }

        @Override
        public void setRaw(String key, Object value) {
            this.setValue("JAVA_OBJECT", key, value);
        }

        @Override
        public void setString(String key, String value) {
            this.setValue("VARCHAR", key, value);
        }

        private void setValue(String type, String key, Object value) {
            Traversed t = this.traverse(this.createRelativeKey(key), true);
            if (t == INVALID_TRAVERSAL) {
                throw new IllegalStateException("could not set " + value + " at " + key);
            }
            Connection conn = DatabaseStorage.this.getConnection();
            try {
                if (!((Traversed)t).found.columns.contains(t.column)) {
                    PreparedStatement stmt = conn.prepareStatement("ALTER TABLE `" + ((Traversed)t).found.name + "` ADD `" + t.column + "` " + type);
                    stmt.execute();
                    DatabaseStorage.closeQuietly(stmt);
                    ((Traversed)t).found.columns.add(t.column);
                }
                DatabaseStorage.this.queryRunner.update(conn, "UPDATE `" + ((Traversed)t).found.name + "` SET `" + t.column + "`= ? WHERE `" + ((Traversed)t).found.primaryKey + "` = ?", value, t.key);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }

        private Traversed traverse(String path, boolean createRelations) {
            Traversed prev = (Traversed)DatabaseStorage.this.traverseCache.get(path);
            if (prev != null) {
                return prev;
            }
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').omitEmptyStrings().trimResults().split((CharSequence)path), String.class);
            Traversed root = this.getRoot();
            if (root == null && parts.length < 2) {
                return INVALID_TRAVERSAL;
            }
            Table table = root != null ? root.found : null;
            String pk = root != null ? root.key : null;
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                boolean contains = DatabaseStorage.this.tables.containsKey(part);
                if (table == null) {
                    if (!createRelations || i + 1 >= parts.length) {
                        return INVALID_TRAVERSAL;
                    }
                    pk = parts[++i];
                    int type = INTEGER.matcher(pk).matches() ? 4 : 12;
                    table = DatabaseStorage.this.createTable(part, type, false);
                    if (table == null) {
                        return INVALID_TRAVERSAL;
                    }
                    table.insert(pk);
                    continue;
                }
                if (!contains && DatabaseStorage.this.createTable(part, 4, true) == null) {
                    return INVALID_TRAVERSAL;
                }
                Table next = (Table)DatabaseStorage.this.tables.get(part);
                if (!table.foreignKeys.containsKey("fk_" + part)) {
                    if (!createRelations) {
                        return INVALID_TRAVERSAL;
                    }
                    DatabaseStorage.this.createForeignKey(table, next);
                }
                if ((pk = DatabaseStorage.this.ensureRelation(pk, table, next)) == null) {
                    return INVALID_TRAVERSAL;
                }
                table = next;
            }
            String setColumn = parts.length == 0 ? null : parts[parts.length - 1];
            Traversed t = new Traversed(table, pk, setColumn);
            DatabaseStorage.this.traverseCache.put(path, t);
            return t;
        }
    }
}

