/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.editor.Equipable;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.npc.ai.NPCHandle;
import net.citizensnpcs.trait.Saddle;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import net.minecraft.server.EntityPig;
import net.minecraft.server.EntityWeatherLighting;
import net.minecraft.server.PathfinderGoalSelector;
import net.minecraft.server.World;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CitizensPigNPC
extends CitizensMobNPC
implements Equipable {
    public CitizensPigNPC(CitizensNPCManager manager, int id, String name) {
        super(manager, id, name, EntityPigNPC.class);
    }

    @Override
    public void equip(Player equipper) {
        ItemStack hand = equipper.getItemInHand();
        if (hand.getType() == Material.SADDLE) {
            if (!this.getBukkitEntity().hasSaddle()) {
                this.getTrait(Saddle.class).toggle();
                equipper.setItemInHand(null);
                Messaging.send((CommandSender)equipper, StringHelper.wrap(this.getName()) + " is now saddled.");
            }
        } else if (this.getBukkitEntity().hasSaddle()) {
            equipper.getWorld().dropItemNaturally(this.getBukkitEntity().getLocation(), new ItemStack(Material.SADDLE, 1));
            this.getTrait(Saddle.class).toggle();
            Messaging.send((CommandSender)equipper, StringHelper.wrap(this.getName()) + " is no longer saddled.");
        }
    }

    public Pig getBukkitEntity() {
        return (Pig)this.getHandle().getBukkitEntity();
    }

    public static class EntityPigNPC
    extends EntityPig
    implements NPCHandle {
        private final CitizensNPC npc;

        public EntityPigNPC(World world, CitizensNPC npc) {
            super(world);
            this.npc = npc;
            this.goalSelector = new PathfinderGoalSelector();
            this.targetSelector = new PathfinderGoalSelector();
        }

        public void a(EntityWeatherLighting entityweatherlighting) {
        }

        public void d_() {
            this.npc.update();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

