/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import net.citizensnpcs.api.util.DatabaseStorage;
import net.citizensnpcs.api.util.QueryType;

public enum DatabaseType {
    H2("org.h2.Driver"),
    MYSQL("com.mysql.jdbc.Driver"),
    POSTGRE("org.postgresql.Driver"),
    SQLITE("org.sqlite.JDBC"){

        @Override
        public String getSpecialSyntaxFor(QueryType type) {
            if (type == QueryType.ADD_COLUMN) {
                return "ADD COLUMN";
            }
            return super.getSpecialSyntaxFor(type);
        }
    };

    private final String driver;
    private boolean loaded = false;

    private DatabaseType(String driver) {
        this.driver = driver;
    }

    public boolean load() {
        if (this.loaded) {
            return true;
        }
        if (DatabaseStorage.loadDriver(DatabaseStorage.class.getClassLoader(), this.driver)) {
            this.loaded = true;
        }
        return this.loaded;
    }

    public static DatabaseType match(String driver) {
        for (DatabaseType type : DatabaseType.values()) {
            if (!type.name().toLowerCase().contains(driver)) continue;
            return type;
        }
        return null;
    }

    public String getSpecialSyntaxFor(QueryType type) {
        return type.getDefaultSyntax();
    }
}

