/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import net.minecraft.server.EntityLiving;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class LookClose
extends Trait
implements Runnable,
Toggleable {
    private boolean enabled = Settings.Setting.DEFAULT_LOOK_CLOSE.asBoolean();
    private Player lookingAt;
    private final NPC npc;

    public LookClose(NPC npc) {
        this.npc = npc;
    }

    private void faceEntity(Entity from, Entity at) {
        if (from.getWorld() != at.getWorld()) {
            return;
        }
        Location loc = from.getLocation();
        double xDiff = at.getLocation().getX() - loc.getX();
        double yDiff = at.getLocation().getY() - loc.getY();
        double zDiff = at.getLocation().getZ() - loc.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yaw = Math.acos(xDiff / distanceXZ) * 180.0 / Math.PI;
        double pitch = Math.acos(yDiff / distanceY) * 180.0 / Math.PI - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        EntityLiving handle = ((CraftLivingEntity)from).getHandle();
        handle.yaw = (float)yaw - 90.0f;
        handle.pitch = (float)pitch;
        handle.X = handle.yaw;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.enabled = key.getBoolean("enabled");
    }

    @Override
    public void run() {
        if (!this.enabled || this.npc.getAI().hasDestination()) {
            return;
        }
        if (this.hasInvalidTarget()) {
            this.findNewTarget();
        } else {
            this.faceEntity((Entity)this.npc.getBukkitEntity(), (Entity)this.lookingAt);
        }
    }

    private void findNewTarget() {
        List nearby = this.npc.getBukkitEntity().getNearbyEntities(2.5, 5.0, 2.5);
        Collections.sort(nearby, new Comparator<Entity>(){

            @Override
            public int compare(Entity o1, Entity o2) {
                double d1 = o1.getLocation().distanceSquared(LookClose.this.npc.getBukkitEntity().getLocation());
                double d2 = o2.getLocation().distanceSquared(LookClose.this.npc.getBukkitEntity().getLocation());
                return Double.compare(d1, d2);
            }
        });
        for (Entity entity : nearby) {
            if (!(entity instanceof Player)) continue;
            this.lookingAt = (Player)entity;
            return;
        }
        this.lookingAt = null;
    }

    private boolean hasInvalidTarget() {
        return this.lookingAt == null || !this.lookingAt.isOnline() || this.lookingAt.getLocation().distanceSquared(this.npc.getBukkitEntity().getLocation()) > 5.0;
    }

    @Override
    public void save(DataKey key) {
        key.setBoolean("enabled", this.enabled);
    }

    @Override
    public boolean toggle() {
        this.enabled = !this.enabled;
        return this.enabled;
    }

    public String toString() {
        return "LookClose{" + this.enabled + "}";
    }
}

