/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.citizensnpcs.util.Messaging;

public class ByIdArray<T>
implements Iterable<T> {
    private final int capacity;
    private Object[] elementData;
    private int highest = Integer.MIN_VALUE;
    private int lowest = Integer.MAX_VALUE;
    private int modCount;
    private int size;

    public ByIdArray() {
        this(1000);
    }

    public ByIdArray(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be less than 0.");
        }
        this.capacity = capacity;
        this.elementData = new Object[capacity];
    }

    public int add(T t) {
        int index = 0;
        while (this.elementData[index++] != null) {
            if (index < this.elementData.length) continue;
            this.ensureCapacity(this.elementData.length + 1);
            index = this.elementData.length - 1;
        }
        this.put(index, t);
        return index;
    }

    public void clear() {
        this.lowest = 0;
        this.size = 0;
        this.highest = 0;
        this.modCount = 0;
        this.elementData = new Object[this.capacity];
    }

    public boolean contains(int index) {
        return this.elementData.length > index && this.elementData[index] != null;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        }
    }

    private void fastRemove(int index) {
        ++this.modCount;
        if (index == this.highest) {
            this.recalcHighest();
        }
        if (index == this.lowest) {
            this.recalcLowest();
        }
        this.elementData[index] = null;
        --this.size;
    }

    public T get(int index) {
        if (index > this.elementData.length) {
            return null;
        }
        return (T)this.elementData[index];
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    public void put(int index, T t) {
        if (t == null) {
            throw new IllegalArgumentException("can't insert a null object");
        }
        ++this.modCount;
        if (index > this.highest) {
            this.highest = index;
        }
        if (index < this.lowest) {
            this.lowest = index;
        }
        this.ensureCapacity(index + 2);
        this.elementData[index] = t;
        ++this.size;
    }

    private void recalcHighest() {
        this.highest = this.elementData.length - 1;
        while (this.highest != 0 && this.elementData[this.highest--] == null) {
        }
    }

    private void recalcLowest() {
        this.lowest = 0;
        while (this.elementData.length > this.lowest && this.elementData[this.lowest++] == null) {
        }
    }

    public T remove(int index) {
        if (index > this.elementData.length || this.elementData[index] == null) {
            return null;
        }
        ++this.modCount;
        if (index == this.highest) {
            this.recalcHighest();
        }
        if (index == this.lowest) {
            this.recalcLowest();
        }
        Object prev = this.elementData[index];
        this.elementData[index] = null;
        if (prev != null) {
            --this.size;
        }
        return (T)prev;
    }

    public int size() {
        return this.size;
    }

    public void trimToSize() {
        if (this.elementData.length > this.highest) {
            this.elementData = Arrays.copyOf(this.elementData, this.highest + 1);
        }
    }

    public static <T> ByIdArray<T> create() {
        return new ByIdArray<T>();
    }

    private class Itr
    implements Iterator<T> {
        private int expected;
        private int idx;

        private Itr() {
            this.expected = ByIdArray.this.modCount;
            if (ByIdArray.this.size > 0) {
                if (ByIdArray.this.highest == Integer.MIN_VALUE || ByIdArray.this.elementData[ByIdArray.this.highest] == null) {
                    ByIdArray.this.recalcHighest();
                }
                if (ByIdArray.this.lowest == Integer.MAX_VALUE || ByIdArray.this.elementData[ByIdArray.this.lowest] == null) {
                    ByIdArray.this.recalcLowest();
                }
                this.idx = ByIdArray.this.lowest;
                if (ByIdArray.this.elementData[ByIdArray.this.lowest] == null) {
                    this.idx = 0;
                    while (ByIdArray.this.elementData.length > this.idx && ByIdArray.this.elementData[this.idx++] == null) {
                    }
                    if (ByIdArray.this.elementData[this.idx] == null) {
                        Messaging.debug("idx is still null!");
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (ByIdArray.this.modCount != this.expected) {
                throw new ConcurrentModificationException();
            }
            return ByIdArray.this.size > 0 && ByIdArray.this.highest + 1 > this.idx;
        }

        @Override
        public T next() {
            if (ByIdArray.this.modCount != this.expected) {
                throw new ConcurrentModificationException();
            }
            Object next = ByIdArray.this.elementData[this.idx];
            if (next == null || this.idx > ByIdArray.this.highest) {
                throw new NoSuchElementException();
            }
            do {
                ++this.idx;
            } while (this.idx != ByIdArray.this.highest + 1 && ByIdArray.this.elementData[this.idx] == null);
            return next;
        }

        @Override
        public void remove() {
            if (ByIdArray.this.modCount != this.expected) {
                throw new ConcurrentModificationException();
            }
            ByIdArray.this.fastRemove(this.idx);
            this.expected = ByIdArray.this.modCount;
            if (this.hasNext()) {
                do {
                    ++this.idx;
                } while (this.idx != ByIdArray.this.highest + 1 && ByIdArray.this.elementData[this.idx] == null);
            }
        }
    }
}

