/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import org.bukkit.entity.Ageable;

public class Age
extends Trait
implements Runnable,
Toggleable {
    private int age = 0;
    private boolean locked = true;
    private final NPC npc;

    public Age(NPC npc) {
        this.npc = npc;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.age = key.getInt("age");
        this.locked = key.getBoolean("locked");
    }

    @Override
    public void onNPCSpawn() {
        if (this.npc.getBukkitEntity() instanceof Ageable) {
            Ageable entity = (Ageable)this.npc.getBukkitEntity();
            entity.setAge(this.age);
            entity.setAgeLock(this.locked);
        }
    }

    @Override
    public void run() {
        if (!this.locked) {
            this.age = ((Ageable)this.npc.getBukkitEntity()).getAge();
        }
    }

    @Override
    public void save(DataKey key) {
        key.setInt("age", this.age);
        key.setBoolean("locked", this.locked);
    }

    public void setAge(int age) {
        this.age = age;
        if (this.npc.getBukkitEntity() instanceof Ageable) {
            ((Ageable)this.npc.getBukkitEntity()).setAge(age);
        }
    }

    @Override
    public boolean toggle() {
        this.locked = !this.locked;
        ((Ageable)this.npc.getBukkitEntity()).setAgeLock(this.locked);
        return this.locked;
    }

    public String toString() {
        return "Age{age=" + this.age + ",locked=" + this.locked + "}";
    }
}

