/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.trait.Toggleable;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityPlayer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class Controllable
extends Trait
implements Runnable,
Listener,
Toggleable {
    private final CitizensNPC npc;
    private boolean enabled;
    private static final double JUMP_VELOCITY = 0.6;

    public Controllable(NPC npc) {
        this.npc = (CitizensNPC)npc;
    }

    private void jump() {
        if (!this.npc.getHandle().onGround) {
            return;
        }
        this.npc.getHandle().motY = 0.6;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.enabled = key.getBoolean("");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        EntityPlayer handle = ((CraftPlayer)event.getPlayer()).getHandle();
        Action performed = event.getAction();
        if (performed == Action.PHYSICAL || !handle.equals((Object)this.npc.getHandle().passenger)) {
            return;
        }
        if (performed == Action.LEFT_CLICK_AIR || performed == Action.LEFT_CLICK_BLOCK) {
            this.jump();
        } else if (-170.0f >= event.getPlayer().getLocation().getPitch()) {
            event.getPlayer().leaveVehicle();
        }
    }

    @EventHandler
    public void onRightClick(NPCRightClickEvent event) {
        if (!event.getNPC().equals(this.npc) || this.npc.getHandle().passenger != null) {
            return;
        }
        EntityPlayer handle = ((CraftPlayer)event.getClicker()).getHandle();
        handle.setPassengerOf((Entity)this.npc.getHandle());
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || this.npc.getHandle().passenger == null) {
            return;
        }
        this.npc.getHandle().motX += this.npc.getHandle().passenger.motX;
        this.npc.getHandle().motZ += this.npc.getHandle().passenger.motZ;
    }

    @Override
    public void save(DataKey key) {
        key.setBoolean("enabled", this.enabled);
    }

    @Override
    public boolean toggle() {
        this.enabled = !this.enabled;
        return this.enabled;
    }
}

