/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.ai.AI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.NavigationCallback;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.PathStrategy;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;

public class CitizensAI
implements AI {
    private final List<WeakReference<NavigationCallback>> callbacks = Lists.newArrayList();
    private PathStrategy executing;
    private final List<GoalEntry> executingGoals = Lists.newArrayList();
    private final List<GoalEntry> goals = Lists.newArrayList();
    private final CitizensNPC npc;
    private boolean paused;

    public CitizensAI(CitizensNPC npc) {
        this.npc = npc;
    }

    @Override
    public void addGoal(int priority, Goal goal) {
        if (this.goals.contains(goal)) {
            return;
        }
        this.goals.add(new GoalEntry(priority, goal));
        Collections.sort(this.goals);
    }

    @Override
    public void cancelDestination() {
        if (this.executing == null) {
            return;
        }
        this.executing = null;
        for (int i = 0; i < this.callbacks.size(); ++i) {
            NavigationCallback next = (NavigationCallback)this.callbacks.get(i).get();
            if (next != null && !next.onCancel(this, NavigationCallback.CancelReason.CANCEL)) continue;
            this.callbacks.remove(i);
        }
    }

    @Override
    public boolean hasDestination() {
        return this.executing != null;
    }

    private boolean isGoalAllowable(GoalEntry test) {
        for (int i = 0; i < this.goals.size(); ++i) {
            GoalEntry item = this.goals.get(i);
            if (item == test || test.priority < item.priority || test.goal.isCompatibleWith(item.goal) || !this.executingGoals.contains(item)) continue;
            return false;
        }
        return true;
    }

    public void pause() {
        this.paused = true;
    }

    @Override
    public void registerNavigationCallback(NavigationCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(new WeakReference<NavigationCallback>(callback));
            callback.onAttach(this);
        }
    }

    public void resume() {
        this.paused = false;
    }

    @Override
    public void setDestination(Location destination) {
        if (destination == null) {
            throw new IllegalArgumentException("destination cannot be null");
        }
        boolean replaced = this.executing != null;
        this.executing = new MCNavigationStrategy(this.npc, destination);
        if (!replaced) {
            return;
        }
        for (int i = 0; i < this.callbacks.size(); ++i) {
            NavigationCallback next = (NavigationCallback)this.callbacks.get(i).get();
            if (next != null && (!replaced || !next.onCancel(this, NavigationCallback.CancelReason.REPLACE)) && !next.onBegin(this)) continue;
            this.callbacks.remove(i);
        }
    }

    @Override
    public void setTarget(LivingEntity target, boolean aggressive) {
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        boolean replaced = this.executing != null;
        this.executing = new MCTargetStrategy(this.npc, target, aggressive);
        if (!replaced) {
            return;
        }
        for (int i = 0; i < this.callbacks.size(); ++i) {
            NavigationCallback next = (NavigationCallback)this.callbacks.get(i).get();
            if (next != null && (!replaced || !next.onCancel(this, NavigationCallback.CancelReason.REPLACE)) && !next.onBegin(this)) continue;
            this.callbacks.remove(i);
        }
    }

    public void update() {
        int i;
        if (this.paused || !this.npc.isSpawned()) {
            return;
        }
        if (this.executing != null && this.executing.update()) {
            this.executing = null;
            for (i = 0; i < this.callbacks.size(); ++i) {
                NavigationCallback next = (NavigationCallback)this.callbacks.get(i).get();
                if (next != null && !next.onCompletion(this)) continue;
                this.callbacks.remove(i);
            }
        }
        for (i = 0; i < this.goals.size(); ++i) {
            GoalEntry entry = this.goals.get(i);
            boolean executing = this.executingGoals.contains(entry);
            if (executing) {
                if (entry.goal.continueExecuting() && this.isGoalAllowable(entry)) continue;
                entry.goal.reset();
                this.executingGoals.remove(entry);
                continue;
            }
            if (!entry.goal.shouldExecute() || !this.isGoalAllowable(entry)) continue;
            entry.goal.start();
            this.executingGoals.add(entry);
        }
        for (i = 0; i < this.executingGoals.size(); ++i) {
            this.executingGoals.get((int)i).goal.update();
        }
    }

    private class GoalEntry
    implements Comparable<GoalEntry> {
        final Goal goal;
        final int priority;

        GoalEntry(int priority, Goal goal) {
            this.priority = priority;
            this.goal = goal;
        }

        @Override
        public int compareTo(GoalEntry o) {
            return o.priority > this.priority ? 1 : (o.priority < this.priority ? -1 : 0);
        }
    }
}

