/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public abstract class Editor
implements Listener {
    private static final Map<String, Editor> editing = new HashMap<String, Editor>();

    public abstract void begin();

    public abstract void end();

    private static void enter(Player player, Editor editor) {
        editor.begin();
        player.getServer().getPluginManager().registerEvents((Listener)editor, player.getServer().getPluginManager().getPlugin("Citizens"));
        editing.put(player.getName(), editor);
    }

    public static void enterOrLeave(Player player, Editor editor) {
        Editor edit = editing.get(player.getName());
        if (edit == null) {
            Editor.enter(player, editor);
        } else if (edit.getClass() == editor.getClass()) {
            Editor.leave(player);
        } else {
            Messaging.sendError((CommandSender)player, "You're already in an editor!");
        }
    }

    public static boolean hasEditor(Player player) {
        return editing.containsKey(player.getName());
    }

    public static void leave(Player player) {
        if (!Editor.hasEditor(player)) {
            return;
        }
        Editor editor = editing.remove(player.getName());
        HandlerList.unregisterAll((Listener)editor);
        editor.end();
    }

    public static void leaveAll() {
        editing.clear();
    }
}

