/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import net.citizensnpcs.trait.text.PageChangePrompt;
import net.citizensnpcs.trait.text.StartPrompt;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class TextRemovePrompt
extends StringPrompt {
    private Text text;

    public TextRemovePrompt(Text text) {
        this.text = text;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        Player player = (Player)context.getForWhom();
        try {
            int index = Integer.parseInt(input);
            if (!this.text.hasIndex(index)) {
                Messaging.sendError((CommandSender)player, "'" + index + "' is not a valid index!");
                return new StartPrompt(this.text);
            }
            this.text.remove(index);
            Messaging.send((CommandSender)player, "<e>Removed <a>entry at index <e>" + index + "<a>.");
            return new StartPrompt(this.text);
        }
        catch (NumberFormatException ex) {
            if (input.equalsIgnoreCase("page")) {
                context.setSessionData((Object)"previous", (Object)this);
                return new PageChangePrompt(this.text);
            }
            Messaging.sendError((CommandSender)player, "Invalid input.");
            return new StartPrompt(this.text);
        }
    }

    public String getPromptText(ConversationContext context) {
        this.text.sendPage((Player)context.getForWhom(), 1);
        return StringHelper.parseColors("<a>Enter the index of the entry you wish to remove or <e>page <a>to view more pages.");
    }
}

