/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.character;

import net.citizensnpcs.api.exception.CharacterException;
import net.citizensnpcs.api.npc.character.Character;
import org.bukkit.entity.EntityType;

public final class CharacterFactory {
    private final Class<? extends Character> character;
    private String name;
    private EntityType[] types;

    public CharacterFactory(Class<? extends Character> character) {
        this.character = character;
    }

    public Character create() throws CharacterException {
        Character create;
        try {
            create = this.character.newInstance();
            if (this.name == null) {
                throw new CharacterException("Character is missing a name!");
            }
            create.setName(this.name);
            if (this.types == null) {
                this.types = new EntityType[0];
            }
            create.setValidTypes(this.types);
        }
        catch (Exception ex) {
            throw new CharacterException("Could not create character: " + ex.getMessage());
        }
        return create;
    }

    public CharacterFactory withName(String name) {
        this.name = name;
        return this;
    }

    public CharacterFactory withTypes(EntityType ... types) {
        this.types = types;
        return this;
    }
}

