/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.logging.Level;
import net.citizensnpcs.CitizensDisableEvent;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.event.CitizensReloadEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.character.CharacterManager;
import net.citizensnpcs.api.scripting.EventRegistrar;
import net.citizensnpcs.api.scripting.ObjectProvider;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.TraitManager;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.DatabaseStorage;
import net.citizensnpcs.api.util.NBTStorage;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.command.CommandManager;
import net.citizensnpcs.command.Injector;
import net.citizensnpcs.command.command.AdminCommands;
import net.citizensnpcs.command.command.EditorCommands;
import net.citizensnpcs.command.command.HelpCommands;
import net.citizensnpcs.command.command.NPCCommands;
import net.citizensnpcs.command.command.ScriptCommands;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.CommandUsageException;
import net.citizensnpcs.command.exception.ServerCommandException;
import net.citizensnpcs.command.exception.UnhandledCommandException;
import net.citizensnpcs.command.exception.WrappedCommandException;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensCharacterManager;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.npc.CitizensTraitManager;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.Metrics;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Citizens
extends JavaPlugin
implements CitizensPlugin {
    private final CitizensCharacterManager characterManager = new CitizensCharacterManager();
    private final CommandManager commands = new CommandManager();
    private boolean compatible;
    private Settings config;
    private ClassLoader contextClassLoader;
    private CitizensNPCManager npcManager;
    private Storage saves;
    private NPCSelector selector;
    private TraitManager traitManager;
    private static final String COMPATIBLE_MC_VERSION = "1.2.5";

    @Override
    public CharacterManager getCharacterManager() {
        return this.characterManager;
    }

    public CommandManager getCommandManager() {
        return this.commands;
    }

    @Override
    public CitizensNPCManager getNPCManager() {
        return this.npcManager;
    }

    public NPCSelector getNPCSelector() {
        return this.selector;
    }

    @Override
    public File getScriptFolder() {
        return new File(this.getDataFolder(), "scripts");
    }

    @Override
    public TraitManager getTraitManager() {
        return this.traitManager;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        block10: {
            try {
                String modifier;
                String[] split = new String[args.length + 1];
                System.arraycopy(args, 0, split, 1, args.length);
                split[0] = cmd.getName().toLowerCase();
                String string = modifier = args.length > 0 ? args[0] : "";
                if (!this.commands.hasCommand(split[0], modifier) && !modifier.isEmpty()) {
                    return this.suggestClosestModifier(sender, split[0], modifier);
                }
                NPC npc = this.selector.getSelected(sender);
                try {
                    this.commands.execute(split, sender, sender, npc);
                }
                catch (ServerCommandException ex) {
                    Messaging.send(sender, "You must be in-game to execute that command.");
                }
                catch (CommandUsageException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                    Messaging.sendError(sender, ex.getUsage());
                }
                catch (WrappedCommandException ex) {
                    throw ex.getCause();
                }
                catch (UnhandledCommandException ex) {
                    return false;
                }
                catch (CommandException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                }
            }
            catch (NumberFormatException ex) {
                Messaging.sendError(sender, "That is not a valid number.");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (!(sender instanceof Player)) break block10;
                Messaging.sendError(sender, "Please report this error: [See console]");
                Messaging.sendError(sender, ex.getClass().getName() + ": " + ex.getMessage());
            }
        }
        return true;
    }

    public void onDisable() {
        Bukkit.getPluginManager().callEvent((Event)new CitizensDisableEvent());
        this.tearDownScripting();
        if (this.compatible) {
            this.save();
            this.despawnNPCs();
            this.npcManager = null;
            this.getServer().getScheduler().cancelTasks((Plugin)this);
        }
        Messaging.log("v" + this.getDescription().getVersion() + " disabled.");
    }

    public void onEnable() {
        String mcVersion = ((CraftServer)this.getServer()).getServer().getVersion();
        this.compatible = mcVersion.startsWith(COMPATIBLE_MC_VERSION);
        if (!this.compatible) {
            Messaging.log(Level.SEVERE, "v" + this.getDescription().getVersion() + " is not compatible with Minecraft v" + mcVersion + ". Disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerScriptHelpers();
        this.config = new Settings(this.getDataFolder());
        this.setupStorage();
        this.npcManager = new CitizensNPCManager(this.saves);
        this.traitManager = new CitizensTraitManager(this);
        this.selector = new NPCSelector(this);
        CitizensAPI.setImplementation(this);
        this.getServer().getPluginManager().registerEvents((Listener)new EventListen(this.npcManager), (Plugin)this);
        this.registerCommands();
        Messaging.log("v" + this.getDescription().getVersion() + " enabled.");
        if (this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Citizens.this.setupNPCs();
                Citizens.this.startMetrics();
            }
        }) == -1) {
            Messaging.log(Level.SEVERE, "Issue enabling plugin. Disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    public void onImplementationChanged() {
        Messaging.severe("Citizens implementation changed, disabling plugin.");
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    private void registerCommands() {
        this.commands.setInjector(new Injector(this));
        this.commands.register(AdminCommands.class);
        this.commands.register(EditorCommands.class);
        this.commands.register(HelpCommands.class);
        this.commands.register(NPCCommands.class);
        this.commands.register(ScriptCommands.class);
    }

    private void registerScriptHelpers() {
        this.setupScripting();
        ScriptCompiler compiler = CitizensAPI.getScriptCompiler();
        compiler.registerGlobalContextProvider(new EventRegistrar(this));
        compiler.registerGlobalContextProvider(new ObjectProvider("plugin", this));
    }

    public void reload() throws NPCLoadException {
        Editor.leaveAll();
        this.config.reload();
        this.despawnNPCs();
        this.setupNPCs();
        this.getServer().getPluginManager().callEvent((Event)new CitizensReloadEvent());
    }

    private void despawnNPCs() {
        Iterator<NPC> itr = this.npcManager.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            itr.remove();
            npc.despawn();
        }
    }

    public void save() {
        for (NPC npc : this.npcManager) {
            ((CitizensNPC)npc).save(this.saves.getKey("npc." + npc.getId()));
        }
        this.saves.save();
    }

    private void setupNPCs() {
        this.saves.load();
        int created = 0;
        int spawned = 0;
        for (DataKey key : this.saves.getKey("npc").getIntegerSubKeys()) {
            int id = Integer.parseInt(key.name());
            if (!key.keyExists("name")) {
                Messaging.log("Could not find a name for the NPC with ID '" + id + "'.");
                continue;
            }
            String unparsedEntityType = key.getString("traits.type", "PLAYER");
            EntityType type = EntityType.fromName((String)unparsedEntityType);
            if (type == null) {
                try {
                    type = EntityType.valueOf((String)unparsedEntityType);
                }
                catch (IllegalArgumentException ex) {
                    Messaging.log("NPC type '" + unparsedEntityType + "' was not recognized. Did you spell it correctly?");
                    continue;
                }
            }
            NPC npc = this.npcManager.createNPC(type, id, key.getString("name"), null);
            ((CitizensNPC)npc).load(key);
            ++created;
            if (!npc.isSpawned()) continue;
            ++spawned;
        }
        Messaging.log("Loaded " + created + " NPCs (" + spawned + " spawned).");
    }

    private void setupScripting() {
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
    }

    private void setupStorage() {
        String type = Settings.Setting.STORAGE_TYPE.asString();
        if (type.equalsIgnoreCase("db") || type.equalsIgnoreCase("database")) {
            try {
                this.saves = new DatabaseStorage(Settings.Setting.DATABASE_DRIVER.asString(), Settings.Setting.DATABASE_URL.asString(), Settings.Setting.DATABASE_USERNAME.asString(), Settings.Setting.DATABASE_PASSWORD.asString());
            }
            catch (SQLException e) {
                e.printStackTrace();
                Messaging.log("Unable to connect to database, falling back to YAML");
            }
        } else if (type.equalsIgnoreCase("nbt")) {
            this.saves = new NBTStorage(this.getDataFolder() + File.separator + Settings.Setting.STORAGE_FILE.asString(), "Citizens NPC Storage");
        }
        if (this.saves == null) {
            this.saves = new YamlStorage(this.getDataFolder() + File.separator + Settings.Setting.STORAGE_FILE.asString(), "Citizens NPC Storage");
        }
        Messaging.log("Save method set to", this.saves.toString());
    }

    private void startMetrics() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Metrics metrics = new Metrics(Citizens.this);
                    if (metrics.isOptOut()) {
                        return;
                    }
                    metrics.addCustomData(new Metrics.Plotter("Total NPCs"){

                        @Override
                        public int getValue() {
                            return Iterators.size(Citizens.this.npcManager.iterator());
                        }
                    });
                    Metrics.Graph graph = metrics.createGraph("Character Type Usage");
                    Citizens.this.characterManager.addPlotters(graph);
                    metrics.start();
                    Messaging.log("Metrics started.");
                }
                catch (IOException ex) {
                    Messaging.log("Unable to load metrics.", ex.getMessage());
                }
            }
        }.start();
    }

    private boolean suggestClosestModifier(CommandSender sender, String command, String modifier) {
        int minDist = Integer.MAX_VALUE;
        String closest = "";
        for (String string : this.commands.getAllCommandModifiers(command)) {
            int distance = StringHelper.getLevenshteinDistance(modifier, string);
            if (minDist <= distance) continue;
            minDist = distance;
            closest = string;
        }
        if (!closest.isEmpty()) {
            sender.sendMessage(ChatColor.GRAY + "Unknown command. Did you mean:");
            sender.sendMessage(StringHelper.wrap(" /") + command + " " + StringHelper.wrap(closest));
            return true;
        }
        return false;
    }

    private void tearDownScripting() {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
    }
}

