/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.trait.Toggleable;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class Controllable
extends Trait
implements Runnable,
Listener,
Toggleable {
    private final CitizensNPC npc;
    private boolean enabled;
    private static final double GROUND_SPEED = 4.0;
    private static final double AIR_SPEED = 1.5;
    private static final double JUMP_VELOCITY = 0.6;

    public Controllable(NPC npc) {
        this.npc = (CitizensNPC)npc;
    }

    private void jump() {
        boolean allowed = this.npc.getHandle().onGround;
        if (!allowed) {
            return;
        }
        this.npc.getHandle().motY = 0.6;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.enabled = key.getBoolean("");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.npc.isSpawned() || !this.enabled) {
            return;
        }
        EntityPlayer handle = ((CraftPlayer)event.getPlayer()).getHandle();
        Action performed = event.getAction();
        if (performed == Action.PHYSICAL || !handle.equals((Object)this.npc.getHandle().passenger)) {
            return;
        }
        if (performed == Action.LEFT_CLICK_AIR || performed == Action.LEFT_CLICK_BLOCK) {
            this.jump();
        }
    }

    @EventHandler
    public void onRightClick(NPCRightClickEvent event) {
        if (!this.npc.isSpawned() || !event.getNPC().equals(this.npc)) {
            return;
        }
        EntityPlayer handle = ((CraftPlayer)event.getClicker()).getHandle();
        if (this.npc.getHandle().passenger != null) {
            if (this.npc.getHandle().passenger == handle) {
                event.getClicker().leaveVehicle();
            }
            return;
        }
        handle.setPassengerOf((Entity)this.npc.getHandle());
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || this.npc.getHandle().passenger == null) {
            return;
        }
        EntityLiving handle = this.npc.getHandle();
        boolean onGround = handle.onGround;
        handle.motX = handle.motX + handle.passenger.motX * (onGround ? 4.0 : 1.5);
        handle.motZ = handle.motZ + handle.passenger.motZ * (onGround ? 4.0 : 1.5);
    }

    @Override
    public void save(DataKey key) {
        key.setBoolean("enabled", this.enabled);
    }

    @Override
    public boolean toggle() {
        this.enabled = !this.enabled;
        return this.enabled;
    }
}

