/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.scripting.CompileCallback;
import net.citizensnpcs.api.scripting.ScriptFactory;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.apache.commons.lang.Validate;

public class Behaviour
extends Trait {
    private final Map<Goal, Integer> addedGoals = Maps.newHashMap();
    private final Function<String, File> fileConverterFunction = new Function<String, File>(){

        public File apply(String arg0) {
            return new File(Behaviour.this.rootFolder, arg0);
        }
    };
    private final File rootFolder = new File(CitizensAPI.getScriptFolder(), "behaviours");
    private final List<File> scripts = Lists.newArrayList();

    public Behaviour() {
        super("behaviour");
        if (!this.rootFolder.exists()) {
            this.rootFolder.mkdirs();
        }
    }

    public void addScripts(Iterable<String> scripts) {
        BehaviourCallback callback = new BehaviourCallback(new Goals());
        Iterable transformed = Iterables.transform(scripts, this.fileConverterFunction);
        CitizensAPI.getScriptCompiler().compile(transformed).withCallback(callback).begin();
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.reset();
        if (!key.keyExists("scripts")) {
            return;
        }
        String scripts = key.getString("scripts");
        this.addScripts(Splitter.on((String)",").split((CharSequence)scripts));
    }

    @Override
    public void onNPCSpawn() {
        for (Map.Entry<Goal, Integer> entry : this.addedGoals.entrySet()) {
            this.npc.getAI().addGoal(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public void onRemove() {
        this.removeGoals();
    }

    private void removeGoals() {
        for (Goal entry : this.addedGoals.keySet()) {
            this.npc.getAI().removeGoal(entry);
        }
    }

    private void reset() {
        this.removeGoals();
        this.scripts.clear();
        this.addedGoals.clear();
    }

    @Override
    public void save(DataKey key) {
        key.setString("scripts", Joiner.on((String)",").join(this.scripts));
    }

    public static class Goals {
        private final Map<Goal, Integer> goals = Maps.newHashMap();

        public void addGoal(int priority, Goal goal) {
            Validate.notNull((Object)goal);
            this.goals.put(goal, priority);
        }
    }

    private class BehaviourCallback
    implements CompileCallback {
        private final Goals goals;

        private BehaviourCallback(Goals goals) {
            this.goals = goals;
        }

        @Override
        public void onCompileTaskFinished() {
            Behaviour.this.addedGoals.putAll(this.goals.goals);
            if (!Behaviour.this.npc.isSpawned()) {
                return;
            }
            for (Map.Entry entry : this.goals.goals.entrySet()) {
                Behaviour.this.npc.getAI().addGoal((Integer)entry.getValue(), (Goal)entry.getKey());
            }
        }

        @Override
        public void onScriptCompiled(ScriptFactory script) {
            script.newInstance().invoke("addGoals", this.goals, Behaviour.this.npc);
        }
    }
}

