/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.util.DataKey;

public class SimpleMetadataStore
implements MetadataStore {
    private final Map<String, Object> normalMetadata = Maps.newHashMap();
    private final Map<String, Object> persistentMetadata = Maps.newHashMap();

    private void checkPrimitive(Object data) {
        boolean isPrimitive;
        Preconditions.checkNotNull((Object)data, (Object)"data cannot be null");
        boolean bl = isPrimitive = data instanceof String || data instanceof Boolean || data instanceof Number;
        if (!isPrimitive) {
            throw new IllegalArgumentException("data is not primitive");
        }
    }

    @Override
    public <T> T get(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        Object normal = this.normalMetadata.get(key);
        if (normal != null) {
            return (T)normal;
        }
        return (T)this.persistentMetadata.get(key);
    }

    @Override
    public <T> T get(String key, T def) {
        T t = this.get(key);
        if (t == null) {
            this.set(key, def);
            return def;
        }
        return t;
    }

    @Override
    public boolean has(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        return this.normalMetadata.containsKey(key) || this.persistentMetadata.containsKey(key);
    }

    @Override
    public void remove(String key) {
        this.normalMetadata.remove(key);
        this.persistentMetadata.remove(key);
    }

    @Override
    public void saveTo(DataKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        for (Map.Entry<String, Object> entry : this.persistentMetadata.entrySet()) {
            key.setRaw(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void set(String key, Object data) {
        Preconditions.checkNotNull((Object)data, (Object)"data cannot be null");
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        if (this.persistentMetadata.containsKey(key)) {
            throw new IllegalArgumentException("conflicting persistent key");
        }
        this.normalMetadata.put(key, data);
    }

    @Override
    public void setPersistent(String key, Object data) {
        Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
        this.checkPrimitive(data);
        if (this.normalMetadata.containsKey(key)) {
            throw new IllegalArgumentException("conflicting normal key");
        }
        this.persistentMetadata.put(key, data);
    }
}

