/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import java.util.Iterator;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.trait.waypoint.Waypoint;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;

public class WaypointGoal
implements Goal {
    private Location currentDestination;
    private Iterator<Waypoint> itr;
    private final Navigator navigator;
    private final Iterable<Waypoint> provider;
    private GoalSelector selector;

    public WaypointGoal(Iterable<Waypoint> provider, Navigator navigator) {
        this.provider = provider;
        this.navigator = navigator;
    }

    private void ensureItr() {
        if (this.itr == null || !this.itr.hasNext()) {
            this.itr = this.provider.iterator();
        }
    }

    @EventHandler
    public void onNavigationCancel(NavigationCancelEvent event) {
        if (!event.getNavigator().equals(this.navigator) || this.currentDestination == null) {
            return;
        }
        if (this.currentDestination.equals((Object)event.getNavigator().getTargetAsLocation())) {
            this.selector.finish();
        }
    }

    public void onProviderChanged() {
        this.itr = this.provider.iterator();
        if (this.currentDestination != null) {
            this.selector.finish();
        }
    }

    @Override
    public void reset() {
        this.currentDestination = null;
        this.selector = null;
    }

    @Override
    public void run() {
    }

    @Override
    public boolean shouldExecute(GoalSelector selector) {
        this.ensureItr();
        boolean shouldExecute = this.itr.hasNext();
        if (shouldExecute) {
            this.selector = selector;
            this.currentDestination = this.itr.next().getLocation();
            this.navigator.setTarget(this.currentDestination);
        }
        return shouldExecute;
    }
}

