/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCCollisionEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.EntityCow;
import net.minecraft.server.PathfinderGoalSelector;
import net.minecraft.server.World;
import org.bukkit.entity.Cow;
import org.bukkit.util.Vector;

public class CitizensCowNPC
extends CitizensMobNPC {
    public CitizensCowNPC(int id, String name) {
        super(id, name, EntityCowNPC.class);
    }

    public Cow getBukkitEntity() {
        return (Cow)this.getHandle().getBukkitEntity();
    }

    public static class EntityCowNPC
    extends EntityCow
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityCowNPC(World world) {
            this(world, null);
        }

        public EntityCowNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.goalSelector = new PathfinderGoalSelector();
                this.targetSelector = new PathfinderGoalSelector();
            }
        }

        public void b_(double x, double y, double z) {
            if (this.npc == null) {
                super.b_(x, y, z);
                return;
            }
            if (NPCCollisionEvent.getHandlerList().getRegisteredListeners().length == 0) {
                return;
            }
            NPCCollisionEvent event = Util.callCollisionEvent(this.npc, new Vector(x, y, z));
            if (!event.isCancelled()) {
                super.b_(x, y, z);
            }
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void z_() {
            super.z_();
            if (this.npc != null) {
                this.npc.update();
            }
        }
    }
}

