/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityOcelot;
import net.minecraft.server.PathfinderGoalSelector;
import net.minecraft.server.World;
import org.bukkit.entity.Ocelot;
import org.bukkit.util.Vector;

public class CitizensOcelotNPC
extends CitizensMobNPC {
    public CitizensOcelotNPC(int id, String name) {
        super(id, name, EntityOcelotNPC.class);
    }

    public Ocelot getBukkitEntity() {
        return (Ocelot)this.getHandle().getBukkitEntity();
    }

    public static class EntityOcelotNPC
    extends EntityOcelot
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityOcelotNPC(World world) {
            this(world, null);
        }

        public EntityOcelotNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.goalSelector = new PathfinderGoalSelector();
                this.targetSelector = new PathfinderGoalSelector();
            }
        }

        public void b_(double x, double y, double z) {
            if (this.npc == null) {
                super.b_(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                return;
            }
            NPCPushEvent event = Util.callPushEvent(this.npc, new Vector(x, y, z));
            if (!event.isCancelled()) {
                super.b_(x, y, z);
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            Util.callCollisionEvent(this.npc, entity);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void z_() {
            super.z_();
            if (this.npc != null) {
                this.npc.update();
            }
        }
    }
}

