/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityGhast;
import net.minecraft.server.PathfinderGoalSelector;
import net.minecraft.server.World;
import org.bukkit.entity.Ghast;
import org.bukkit.util.Vector;

public class CitizensGhastNPC
extends CitizensMobNPC {
    public CitizensGhastNPC(int id, String name) {
        super(id, name, EntityGhastNPC.class);
    }

    public Ghast getBukkitEntity() {
        return (Ghast)this.getHandle().getBukkitEntity();
    }

    public static class EntityGhastNPC
    extends EntityGhast
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityGhastNPC(World world) {
            this(world, null);
        }

        public EntityGhastNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.goalSelector = new PathfinderGoalSelector();
                this.targetSelector = new PathfinderGoalSelector();
            }
        }

        public void b_(double x, double y, double z) {
            if (this.npc == null) {
                super.b_(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                return;
            }
            NPCPushEvent event = Util.callPushEvent(this.npc, new Vector(x, y, z));
            if (!event.isCancelled()) {
                super.b_(x, y, z);
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            Util.callCollisionEvent(this.npc, entity);
        }

        public void d_() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.d_();
            }
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

