/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import net.citizensnpcs.api.scripting.CompileCallback;
import net.citizensnpcs.api.scripting.Script;
import net.citizensnpcs.api.scripting.ScriptFactory;
import org.apache.commons.lang.Validate;

public class ScriptRunnerCallback
implements CompileCallback {
    private final Object[] methodArgs;
    private final String methodToInvoke;

    public ScriptRunnerCallback() {
        this.methodToInvoke = null;
        this.methodArgs = null;
    }

    public ScriptRunnerCallback(String methodToInvoke) {
        this(methodToInvoke, null);
    }

    public ScriptRunnerCallback(String methodToInvoke, Object[] methodArgs) {
        Validate.notNull((Object)methodToInvoke, (String)"method cannot be null");
        this.methodToInvoke = methodToInvoke;
        this.methodArgs = methodArgs;
    }

    private void invokeMethodIfAvailable(Script script) {
        if (this.methodToInvoke == null) {
            return;
        }
        script.invoke(this.methodToInvoke, this.methodArgs);
    }

    @Override
    public void onCompileTaskFinished() {
    }

    @Override
    public void onScriptCompiled(ScriptFactory factory) {
        Script script = factory.newInstance();
        this.invokeMethodIfAvailable(script);
    }
}

