/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Nullable;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class MemoryDataKey
extends DataKey {
    private final ConfigurationSection section;

    public MemoryDataKey() {
        this.section = new MemoryConfiguration();
    }

    private MemoryDataKey(ConfigurationSection configurationSection) {
        this.section = configurationSection;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.section.getBoolean(key);
    }

    @Override
    public double getDouble(String key) {
        return this.section.getDouble(key);
    }

    @Override
    public int getInt(String key) {
        return this.section.getInt(key);
    }

    @Override
    public long getLong(String key) {
        return this.section.getLong(key);
    }

    @Override
    public Object getRaw(String key) {
        return this.section.get(key);
    }

    @Override
    public DataKey getRelative(String relative) {
        ConfigurationSection sub = this.section.getConfigurationSection(relative);
        if (sub == null) {
            this.section.createSection(relative);
        }
        return new MemoryDataKey(sub);
    }

    @Override
    public String getString(String key) {
        return this.section.getString(key);
    }

    @Override
    public Iterable<DataKey> getSubKeys() {
        Set keys = this.section.getKeys(false);
        return Iterables.transform((Iterable)keys, (Function)new Function<String, DataKey>(){

            public DataKey apply(@Nullable String input) {
                ConfigurationSection sub = MemoryDataKey.this.section.getConfigurationSection(input);
                return sub == null ? null : new MemoryDataKey(sub);
            }
        });
    }

    @Override
    public boolean keyExists(String key) {
        return this.section.isSet(key);
    }

    @Override
    public String name() {
        return this.section.getName();
    }

    @Override
    public void removeKey(String key) {
        this.section.set(key, null);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.section.set(key, (Object)value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.section.set(key, (Object)value);
    }

    @Override
    public void setInt(String key, int value) {
        this.section.set(key, (Object)value);
    }

    @Override
    public void setLong(String key, long value) {
        this.section.set(key, (Object)value);
    }

    @Override
    public void setRaw(String key, Object value) {
        this.section.set(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.section.set(key, (Object)value);
    }
}

