/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Nullable;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class MemoryDataKey
extends DataKey {
    private final ConfigurationSection section;
    private final String path;

    public MemoryDataKey() {
        this.section = new MemoryConfiguration();
        this.path = "";
    }

    private MemoryDataKey(ConfigurationSection configurationSection, String path) {
        this.section = configurationSection;
        this.path = path;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.section.getBoolean(this.getKeyFor(key));
    }

    @Override
    public double getDouble(String key) {
        return this.section.getDouble(this.getKeyFor(key));
    }

    @Override
    public int getInt(String key) {
        return this.section.getInt(this.getKeyFor(key));
    }

    @Override
    public long getLong(String key) {
        return this.section.getLong(this.getKeyFor(key));
    }

    @Override
    public Object getRaw(String key) {
        return this.section.get(this.getKeyFor(key));
    }

    @Override
    public DataKey getRelative(String relative) {
        ConfigurationSection sub = this.section.getConfigurationSection(relative);
        if (sub == null) {
            sub = this.section.createSection(relative);
        }
        return new MemoryDataKey(sub, this.getKeyFor(relative));
    }

    @Override
    public String getString(String key) {
        return this.section.getString(this.getKeyFor(key));
    }

    @Override
    public Iterable<DataKey> getSubKeys() {
        Set keys = this.section.getKeys(false);
        return Iterables.transform((Iterable)keys, (Function)new Function<String, DataKey>(){

            public DataKey apply(@Nullable String input) {
                ConfigurationSection sub = MemoryDataKey.this.section.getConfigurationSection(input);
                return sub == null ? null : new MemoryDataKey(sub, MemoryDataKey.this.getKeyFor(sub.getName()));
            }
        });
    }

    @Override
    public boolean keyExists(String key) {
        return this.section.isSet(key);
    }

    @Override
    public String name() {
        return this.section.getName();
    }

    @Override
    public void removeKey(String key) {
        this.section.set(this.getKeyFor(key), null);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.section.set(this.getKeyFor(key), (Object)value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.section.set(this.getKeyFor(key), (Object)value);
    }

    @Override
    public void setInt(String key, int value) {
        this.section.set(this.getKeyFor(key), (Object)value);
    }

    @Override
    public void setLong(String key, long value) {
        this.section.set(this.getKeyFor(key), (Object)value);
    }

    @Override
    public void setRaw(String key, Object value) {
        this.section.set(this.getKeyFor(key), value);
    }

    @Override
    public void setString(String key, String value) {
        this.section.set(this.getKeyFor(key), (Object)value);
    }

    private String getKeyFor(String key) {
        if (key.isEmpty()) {
            return this.path;
        }
        if (key.charAt(0) == '.') {
            return this.path.isEmpty() ? key.substring(1, key.length()) : this.path + key;
        }
        return this.path.isEmpty() ? key : this.path + "." + key;
    }
}

